/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.dirtycheck;

import com.datastax.driver.core.querybuilder.Update;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class DirtyCheckChangeSet {
    private final CollectionAndMapChangeType changeType;
    private final PropertyMeta propertyMeta;
    protected List<Object> listChanges = new ArrayList<Object>();
    protected ElementAtIndex listChangeAtIndex = null;
    protected Set<Object> setChanges = new HashSet<Object>();
    protected Map<Object, Object> mapChanges = new HashMap<Object, Object>();

    public DirtyCheckChangeSet(PropertyMeta propertyMeta, CollectionAndMapChangeType changeType) {
        this.propertyMeta = propertyMeta;
        this.changeType = changeType;
    }

    public List<Object> getEncodedListChanges() {
        if (CollectionUtils.isNotEmpty(this.listChanges)) {
            return (List)this.propertyMeta.forTranscoding().encodeToCassandra(this.listChanges);
        }
        return this.listChanges;
    }

    public ElementAtIndex getEncodedListChangeAtIndex() {
        if (this.listChangeAtIndex != null && this.listChangeAtIndex.getElement() != null) {
            Object encodedElement = ((List)this.propertyMeta.forTranscoding().encodeToCassandra(this.listChangeAtIndex.getElementAsList())).get(0);
            return new ElementAtIndex(this.listChangeAtIndex.getIndex(), encodedElement);
        }
        return this.listChangeAtIndex;
    }

    public Set<Object> getEncodedSetChanges() {
        if (CollectionUtils.isNotEmpty(this.setChanges)) {
            return (Set)this.propertyMeta.forTranscoding().encodeToCassandra(this.setChanges);
        }
        return this.setChanges;
    }

    public Map<Object, Object> getEncodedMapChanges() {
        if (MapUtils.isNotEmpty(this.mapChanges)) {
            return (Map)this.propertyMeta.forTranscoding().encodeToCassandra(this.mapChanges);
        }
        return this.mapChanges;
    }

    public CollectionAndMapChangeType getChangeType() {
        return this.changeType;
    }

    public PropertyMeta getPropertyMeta() {
        return this.propertyMeta;
    }

    public Update.Assignments generateUpdateForAddedElements(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForAddedElements(conditions);
    }

    public Update.Assignments generateUpdateForRemovedElements(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForRemovedElements(conditions);
    }

    public Update.Assignments generateUpdateForAppendedElements(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForAppendedElements(conditions);
    }

    public Update.Assignments generateUpdateForPrependedElements(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForPrependedElements(conditions);
    }

    public Update.Assignments generateUpdateForRemoveListElements(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForRemoveListElements(conditions);
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForSetAtIndexElement(Update.Conditions conditions) {
        ElementAtIndex elementAtIndex = this.getEncodedListChangeAtIndex();
        int index = elementAtIndex.getIndex();
        Object encoded = elementAtIndex.getElement();
        Update.Assignments assignments = this.propertyMeta.forStatementGeneration().generateUpdateForSetAtIndexElement(conditions, index, encoded);
        return Pair.create(assignments, new Object[]{index, encoded});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForRemovedAtIndexElement(Update.Conditions conditions) {
        Update.Assignments assignments = this.propertyMeta.forStatementGeneration().generateUpdateForRemovedAtIndexElement(conditions, this.listChangeAtIndex.index);
        return Pair.create(assignments, new Object[]{this.listChangeAtIndex.index, null});
    }

    public Update.Assignments generateUpdateForAddedEntries(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForAddedEntries(conditions);
    }

    public Update.Assignments generateUpdateForRemovedKey(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForRemovedKey(conditions);
    }

    public Update.Assignments generateUpdateForRemoveAll(Update.Conditions conditions) {
        return this.propertyMeta.forStatementGeneration().generateUpdateForRemoveAll(conditions);
    }

    void setListChanges(List<Object> listChanges) {
        this.listChanges = listChanges;
    }

    void setListChangeAtIndex(ElementAtIndex listChangeAtIndex) {
        this.listChangeAtIndex = listChangeAtIndex;
    }

    void setSetChanges(Set<Object> setChanges) {
        this.setChanges = setChanges;
    }

    void setMapChanges(Map<Object, Object> mapChanges) {
        this.mapChanges = mapChanges;
    }

    public List<Object> getRawListChanges() {
        return this.listChanges;
    }

    public Set<Object> getRawSetChanges() {
        return this.setChanges;
    }

    public Map<Object, Object> getRawMapChanges() {
        return this.mapChanges;
    }

    public String toString() {
        return "DirtyCheckChangeSet{changeType=" + (Object)((Object)this.changeType) + ", propertyMeta=" + this.propertyMeta + ", listChanges=" + this.listChanges + ", listChangeAtIndex=" + this.listChangeAtIndex + ", setChanges=" + this.setChanges + ", mapChanges=" + this.mapChanges + '}';
    }

    public static class ElementAtIndex {
        private int index;
        private Object element;

        public ElementAtIndex(int index, Object element) {
            this.index = index;
            this.element = element;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getElement() {
            return this.element;
        }

        public List<Object> getElementAsList() {
            return Arrays.asList(this.element);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementAtIndex that = (ElementAtIndex)o;
            return this.index == that.index && !(this.element == null ? that.element != null : !this.element.equals(that.element));
        }

        public int hashCode() {
            int result = this.index;
            result = 31 * result + (this.element != null ? this.element.hashCode() : 0);
            return result;
        }
    }
}

