/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityValidator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.options.Options;
import java.util.Map;

public class OptionsValidator {
    protected EntityValidator entityValidator = EntityValidator.Singleton.INSTANCE.get();

    public void validateOptionsForUpsert(Object entity, Map<Class<?>, EntityMeta> entityMetaMap, Options options) {
        this.validateNoTtlForClusteredCounter(entity, entityMetaMap, options);
        this.validateNoLWTConditionsAndTimestamp(options);
    }

    public void validateNoLWTConditionsAndTimestamp(Options options) {
        Validator.validateFalse(options.isIfNotExists() && options.hasTimestamp(), "Cannot provide custom timestamp for insert operations using Light Weight Transaction", new Object[0]);
        Validator.validateFalse(options.hasLWTConditions() && options.hasTimestamp(), "Cannot provide custom timestamp for update operations using Light Weight Transaction", new Object[0]);
    }

    public boolean isOptionsValidForBatch(Options options) {
        boolean valid = true;
        if (options.getConsistencyLevel().isPresent() || options.hasAsyncListeners()) {
            valid = false;
        }
        return valid;
    }

    public void validateNoAsyncListener(Options options) {
        Validator.validateFalse(options.hasAsyncListeners(), "Cannot provide custom asynchronous listener for this operation", new Object[0]);
    }

    private void validateNoTtlForClusteredCounter(Object entity, Map<Class<?>, EntityMeta> entityMetaMap, Options options) {
        if (options.getTtl().isPresent()) {
            this.entityValidator.validateNotClusteredCounter(entity, entityMetaMap);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final OptionsValidator instance = new OptionsValidator();

        public OptionsValidator get() {
            return this.instance;
        }
    }
}

