/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityValidator {
    private static final Logger log = LoggerFactory.getLogger(EntityValidator.class);
    private EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();

    public void validateEntity(Object entity, Map<Class<?>, EntityMeta> entityMetaMap) {
        Validator.validateNotNull(entity, "Entity should not be null", new Object[0]);
        Class baseClass = this.proxifier.deriveBaseClass(entity);
        EntityMeta entityMeta = entityMetaMap.get(baseClass);
        this.validateEntity(entity, entityMeta);
    }

    public void validateEntity(Object entity, EntityMeta entityMeta) {
        log.trace("Validate entity {}", entity);
        Validator.validateNotNull(entityMeta, "The entity %s is not managed by Achilles", entity.getClass().getCanonicalName());
        Object rawEntity = this.proxifier.getRealObject(entity);
        Object primaryKey = entityMeta.forOperations().getPrimaryKey(rawEntity);
        if (primaryKey == null) {
            throw new IllegalArgumentException("Cannot get primary key for entity " + rawEntity.getClass().getCanonicalName());
        }
        if (entityMeta.hasStaticColumns()) {
            this.validatePrimaryKeyForEntityWithStaticsColumns(entityMeta, entity, primaryKey);
        } else {
            this.validatePrimaryKey(entityMeta.getIdMeta(), primaryKey);
        }
    }

    public void validatePrimaryKey(PropertyMeta idMeta, Object primaryKey) {
        log.trace("Validate primary key {} for entity class {}", primaryKey, (Object)idMeta.getEntityClassName());
        if (idMeta.structure().isCompoundPK()) {
            List<Object> components = idMeta.forTranscoding().encodeToComponents(primaryKey, false);
            for (Object component : components) {
                Validator.validateNotNull(component, "The compound primary key '%s' component should not be null", idMeta.getPropertyName());
            }
        }
    }

    private void validatePrimaryKeyForEntityWithStaticsColumns(EntityMeta entityMeta, Object entity, Object primaryKey) {
        log.trace("Validate primary key {} for entity class {}", primaryKey, (Object)entityMeta.getClassName());
        PropertyMeta idMeta = entityMeta.getIdMeta();
        List<PropertyMeta> allMetasExceptIdAndCounters = entityMeta.getAllMetasExceptIdAndCounters();
        int nonNullCount = 0;
        int nonNullStaticCount = 0;
        for (PropertyMeta propertyMeta : allMetasExceptIdAndCounters) {
            Object value = propertyMeta.forValues().getValueFromField(entity);
            if (value == null) continue;
            ++nonNullCount;
            if (!propertyMeta.structure().isStaticColumn()) continue;
            ++nonNullStaticCount;
        }
        if (idMeta.structure().isCompoundPK()) {
            boolean encodeOnlyPartitionKey = nonNullCount == nonNullStaticCount;
            List<Object> components = idMeta.forTranscoding().encodeToComponents(primaryKey, encodeOnlyPartitionKey);
            for (Object component : components) {
                Validator.validateNotNull(component, "The compound primary key '%s' component should not be null", idMeta.getPropertyName());
            }
        }
    }

    public void validateNotClusteredCounter(Object entity, Map<Class<?>, EntityMeta> entityMetaMap) {
        log.trace("Validate that entity {} is not a clustered counter", entity);
        Class baseClass = this.proxifier.deriveBaseClass(entity);
        EntityMeta entityMeta = entityMetaMap.get(baseClass);
        Validator.validateFalse(entityMeta.structure().isClusteredCounter(), "The entity '%s' is a clustered counter and does not support insert/update with TTL", entity);
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityValidator instance = new EntityValidator();

        public EntityValidator get() {
            return this.instance;
        }
    }
}

