/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaRowExtractor;
import info.archinnov.achilles.internal.persistence.operations.InternalCounterBuilder;
import info.archinnov.achilles.internal.reflection.RowMethodInvoker;
import info.archinnov.achilles.type.Counter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMapper {
    private static final Logger log = LoggerFactory.getLogger(EntityMapper.class);
    private RowMethodInvoker cqlRowInvoker = RowMethodInvoker.Singleton.INSTANCE.get();

    public void setNonCounterPropertiesToEntity(Row row, EntityMeta entityMeta, Object entity, EntityMeta.EntityState entityState) {
        log.debug("Set non-counter properties to entity class {} from fetched CQL row", (Object)entityMeta.getClassName());
        for (PropertyMeta pm : entityMeta.getAllMetasExceptCounters()) {
            this.setPropertyToEntity(row, entityMeta, pm, entity, entityState);
        }
    }

    public void setPropertyToEntity(Row row, EntityMeta meta, PropertyMeta pm, Object entity, EntityMeta.EntityState entityState) {
        log.debug("Set property {} value from fetched CQL row", (Object)pm.getPropertyName());
        if (row != null) {
            PropertyMetaRowExtractor rowExtractor = pm.forRowExtraction();
            if (pm.structure().isCompoundPK()) {
                Object compoundKey = rowExtractor.extractCompoundPrimaryKeyFromRow(row, meta, entityState);
                pm.forValues().setValueToField(entity, compoundKey);
            } else {
                Object value = rowExtractor.invokeOnRowForFields(row);
                pm.forValues().setValueToField(entity, value);
            }
        }
    }

    public <T> T mapRowToEntityWithPrimaryKey(EntityMeta meta, Row row, Map<String, PropertyMeta> propertiesMap, EntityMeta.EntityState entityState) {
        log.debug("Map CQL row to entity of class {}", (Object)meta.getClassName());
        T entity = null;
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        if (columnDefinitions != null) {
            entity = meta.forOperations().instanciate();
            for (ColumnDefinitions.Definition column : columnDefinitions) {
                String columnName = column.getName();
                PropertyMeta pm = propertiesMap.get(columnName);
                if (pm == null) continue;
                Object value = pm.forRowExtraction().invokeOnRowForFields(row);
                pm.forValues().setValueToField(entity, value);
            }
            PropertyMeta idMeta = meta.getIdMeta();
            if (idMeta.structure().isCompoundPK()) {
                Object compoundKey = idMeta.forRowExtraction().extractCompoundPrimaryKeyFromRow(row, meta, entityState);
                idMeta.forValues().setValueToField(entity, compoundKey);
            }
        }
        return entity;
    }

    public void setValuesToClusteredCounterEntity(Row row, EntityMeta entityMeta, Object clusteredEntity) {
        log.debug("Set values to clustered counter entity class {} from fetched CQL row", (Object)entityMeta.getClassName());
        for (PropertyMeta pm : entityMeta.getAllCounterMetas()) {
            this.setCounterToEntity(pm, clusteredEntity, row);
        }
    }

    public void setCounterToEntity(PropertyMeta counterMeta, Object entity, Long counterValue) {
        if (log.isDebugEnabled()) {
            log.debug("Set counter value {} to property {} of entity class {}", new Object[]{counterValue, counterMeta.getPropertyName(), counterMeta.getEntityClassName()});
        }
        Counter counter = InternalCounterBuilder.initialValue(counterValue);
        counterMeta.forValues().setValueToField(entity, counter);
    }

    public void setCounterToEntity(PropertyMeta counterMeta, Object entity, Row row) {
        log.debug("Set counter value to property {} of entity class {} from CQL row", (Object)counterMeta.getPropertyName(), (Object)counterMeta.getEntityClassName());
        Long counterValue = this.cqlRowInvoker.invokeOnRowForType(row, Long.class, counterMeta.getCQLColumnName());
        this.setCounterToEntity(counterMeta, entity, counterValue);
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityMapper instance = new EntityMapper();

        public EntityMapper get() {
            return this.instance;
        }
    }
}

