/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityInitializer {
    private static final Logger log = LoggerFactory.getLogger(EntityInitializer.class);

    public <T> void initializeEntity(T entity, EntityMeta entityMeta) {
        log.debug("Initializing lazy fields for entity {} of class {}", entity, (Object)entityMeta.getClassName());
        for (PropertyMeta propertyMeta : entityMeta.getAllCounterMetas()) {
            propertyMeta.forValues().forceLoad(entity);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityInitializer instance = new EntityInitializer();

        public EntityInitializer get() {
            return this.instance;
        }
    }
}

