/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.consistency.ConsistencyOverrider;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.type.ConsistencyLevel;

public class CounterLoader {
    private EntityMapper mapper = EntityMapper.Singleton.INSTANCE.get();
    private ConsistencyOverrider overrider = ConsistencyOverrider.Singleton.INSTANCE.get();
    private AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();

    public <T> AchillesFuture<T> loadClusteredCounters(final EntityOperations context) {
        final EntityMeta entityMeta = context.getEntityMeta();
        final Object primaryKey = context.getPrimaryKey();
        ListenableFuture<Row> futureRow = context.getClusteredCounter();
        Function rowToEntity = new Function<Row, T>(){

            public T apply(Row row) {
                Object entity = null;
                if (row != null) {
                    entity = entityMeta.forOperations().instanciate();
                    entityMeta.getIdMeta().forValues().setValueToField(entity, primaryKey);
                    for (PropertyMeta counterMeta : context.getAllCountersMeta()) {
                        CounterLoader.this.mapper.setCounterToEntity(counterMeta, entity, row);
                    }
                }
                return entity;
            }
        };
        ListenableFuture futureEntity = this.asyncUtils.transformFuture(futureRow, rowToEntity);
        return this.asyncUtils.buildInterruptible(futureEntity);
    }

    public void loadClusteredCounterColumn(EntityOperations context, Object realObject, PropertyMeta counterMeta) {
        Long counterValue = context.getClusteredCounterColumn(counterMeta);
        this.mapper.setCounterToEntity(counterMeta, realObject, counterValue);
    }

    public void loadCounter(EntityOperations context, Object entity, PropertyMeta counterMeta) {
        ConsistencyLevel readLevel = this.overrider.getReadLevel(context, counterMeta);
        Long initialCounterValue = context.getSimpleCounter(counterMeta, readLevel);
        this.mapper.setCounterToEntity(counterMeta, entity, initialCounterValue);
    }

    public static enum Singleton {
        INSTANCE;

        private final CounterLoader instance = new CounterLoader();

        public CounterLoader get() {
            return this.instance;
        }
    }
}

