/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing.validator;

import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityParsingValidator {
    private static final Logger log = LoggerFactory.getLogger(EntityParsingValidator.class);

    public void validateHasIdMeta(Class<?> entityClass, PropertyMeta idMeta) {
        log.debug("Validate that entity class {} has an id meta", (Object)entityClass.getCanonicalName());
        Validator.validateBeanMappingFalse(idMeta == null, "The entity '" + entityClass.getCanonicalName() + "' should have at least one field with info.archinnov.achilles.annotations.PartitionKey/info.archinnov.achilles.annotations.CompoundPrimaryKey annotation", new Object[0]);
    }

    public void validateStaticColumns(EntityMeta entityMeta, PropertyMeta idMeta) {
        String className = entityMeta.getClassName();
        Collection<PropertyMeta> propertyMetas = entityMeta.getPropertyMetas().values();
        int staticColumnsCount = FluentIterable.from(propertyMetas).filter(PropertyMeta.STATIC_COLUMN_FILTER).size();
        if (staticColumnsCount > 0) {
            Validator.validateBeanMappingTrue(idMeta.structure().isClustered(), "The entity class '%s' cannot have a static column because it does not declare any clustering column", className);
        }
        if (entityMeta.structure().isClusteredCounter()) {
            int propertyMetasCount;
            int staticCountersCount = FluentIterable.from(propertyMetas).filter(PropertyMeta.STATIC_COLUMN_FILTER).filter(PropertyMeta.COUNTER_COLUMN_FILTER).size();
            Validator.validateBeanMappingFalse(staticCountersCount == (propertyMetasCount = entityMeta.getAllMetasExceptId().size()), "The entity class '%s' is a clustered counter and thus cannot have only static counter column", className);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityParsingValidator instance = new EntityParsingValidator();

        public EntityParsingValidator get() {
            return this.instance;
        }
    }
}

