/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.type.NamingStrategy;
import java.util.Arrays;
import java.util.UnknownFormatConversionException;
import org.apache.commons.lang3.StringUtils;

public class NamingHelper {
    public static final Function<String, String> TO_LOWER_CASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toLowerCase();
        }
    };

    public static String applyNamingStrategy(String name, NamingStrategy namingStrategy) {
        switch (namingStrategy) {
            case SNAKE_CASE: {
                return NamingHelper.toSnakeCase(name);
            }
            case CASE_SENSITIVE: {
                return NamingHelper.toCaseSensitive(name);
            }
            case LOWER_CASE: {
                return name.toLowerCase();
            }
        }
        throw new UnknownFormatConversionException(String.format("Cannot convert name '%s' to unknow naming strategy '%s'", name, namingStrategy.name()));
    }

    private static String toCaseSensitive(String name) {
        if (name.equals(name.toLowerCase())) {
            return name;
        }
        return "\"" + name + "\"";
    }

    private static String toSnakeCase(String name) {
        String[] tokens = StringUtils.splitByCharacterTypeCamelCase((String)name);
        FluentIterable lowerCaseTokens = FluentIterable.from(Arrays.asList(tokens)).filter(Predicates.notNull()).transform(TO_LOWER_CASE);
        return Joiner.on((char)'_').join((Iterable)lowerCaseTokens).replaceAll("_+", "_");
    }
}

