/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.internal.metadata.holder.CompoundPKProperties;
import info.archinnov.achilles.internal.metadata.holder.CompoundPKPropertiesBuilder;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.parsing.ComponentOrderingParser;
import info.archinnov.achilles.internal.metadata.parsing.PropertyFilter;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundPKParser {
    private static final Logger log = LoggerFactory.getLogger(CompoundPKParser.class);
    private PropertyFilter filter = PropertyFilter.Singleton.INSTANCE.get();
    private final PropertyParsingContext context;

    public CompoundPKParser(PropertyParsingContext context) {
        this.context = context;
    }

    public CompoundPKProperties parseCompoundPK(Class<?> compoundPKClass, PropertyParser propertyParser) {
        log.debug("Parse compound primary key class {} ", (Object)compoundPKClass.getCanonicalName());
        ComponentOrderingParser parser = ComponentOrderingParser.determineAppropriateParser(compoundPKClass, this.context);
        Map<Integer, Field> components = parser.extractComponentsOrdering(compoundPKClass);
        List<Create.Options.ClusteringOrder> clusteringOrders = parser.extractClusteringOrder(compoundPKClass);
        CompoundPKProperties compoundPKProperties = this.buildComponentMetas(propertyParser, compoundPKClass, components, clusteringOrders);
        log.trace("Built compound primary key properties : {}", (Object)compoundPKProperties);
        return compoundPKProperties;
    }

    private CompoundPKProperties buildComponentMetas(PropertyParser propertyParser, Class<?> compoundPKClass, Map<Integer, Field> components, List<Create.Options.ClusteringOrder> clusteringOrders) {
        log.debug("Build components meta data for compound primary key class {}", (Object)compoundPKClass.getCanonicalName());
        CompoundPKPropertiesBuilder partitionKeysBuilder = new CompoundPKPropertiesBuilder();
        CompoundPKPropertiesBuilder clusteringKeysBuilder = new CompoundPKPropertiesBuilder();
        clusteringKeysBuilder.setClusteringOrders(clusteringOrders);
        this.buildPartitionAndClusteringKeys(propertyParser, compoundPKClass, components, partitionKeysBuilder, clusteringKeysBuilder);
        return CompoundPKPropertiesBuilder.buildCompoundPKProperties(partitionKeysBuilder.buildPartitionKeys(), clusteringKeysBuilder.buildClusteringKeys(), this.context.getCurrentEntityClass().getCanonicalName());
    }

    private void buildPartitionAndClusteringKeys(PropertyParser propertyParser, Class<?> compoundPKClass, Map<Integer, Field> components, CompoundPKPropertiesBuilder partitionKeysBuilder, CompoundPKPropertiesBuilder clusteringKeysBuilder) {
        log.debug("Build components meta data for compound primary key class {}", (Object)compoundPKClass.getCanonicalName());
        for (Integer order : components.keySet()) {
            Field compositeKeyField = components.get(order);
            Class<?> type = compositeKeyField.getType();
            String propertyName = compositeKeyField.getName();
            Validator.validateBeanMappingFalse(List.class.isAssignableFrom(type), "The column '%s' cannot be a list because it belongs to the partition key", propertyName);
            Validator.validateBeanMappingFalse(Set.class.isAssignableFrom(type), "The column '%s' cannot be a set because it belongs to the partition key", propertyName);
            Validator.validateBeanMappingFalse(Map.class.isAssignableFrom(type), "The column '%s' cannot be a map because it belongs to the partition key", propertyName);
            PropertyMeta propertyMeta = propertyParser.parseSimpleProperty(this.context.duplicateForField(compositeKeyField));
            if (this.filter.hasAnnotation(compositeKeyField, PartitionKey.class)) {
                partitionKeysBuilder.addPropertyMeta(propertyMeta);
                continue;
            }
            clusteringKeysBuilder.addPropertyMeta(propertyMeta);
        }
        if (partitionKeysBuilder.getPropertyMetas().isEmpty()) {
            PropertyMeta partitionMeta = clusteringKeysBuilder.getPropertyMetas().remove(0);
            partitionKeysBuilder.addPropertyMeta(partitionMeta);
        }
    }
}

