/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.base.Optional;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.utils.Pair;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaStatementGenerator
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaStatementGenerator.class);

    PropertyMetaStatementGenerator(PropertyMeta meta) {
        super(meta);
    }

    public Insert generateInsertPrimaryKey(Insert insert, boolean onlyStaticColumns) {
        log.debug("Generate INSERT primary key for id meta {}", (Object)this.meta);
        if (this.meta.structure().isCompoundPK()) {
            if (onlyStaticColumns) {
                for (PropertyMeta partitionComponents : this.meta.getCompoundPKProperties().getPartitionComponents().propertyMetas) {
                    String cqlColumnName = partitionComponents.getCQLColumnName();
                    insert.value(cqlColumnName, (Object)QueryBuilder.bindMarker((String)cqlColumnName));
                }
            } else {
                for (String component : this.meta.getCompoundPKProperties().getCQLComponentNames()) {
                    insert.value(component, (Object)QueryBuilder.bindMarker((String)component));
                }
            }
            return insert;
        }
        return insert.value(this.meta.getCQLColumnName(), (Object)QueryBuilder.bindMarker((String)this.meta.getCQLColumnName()));
    }

    public RegularStatement generateWhereClauseForSelect(Optional<PropertyMeta> pmO, Select from) {
        log.debug("Generate SELECT WHERE clause for property meta {} with static column ? {}", (Object)this.meta, (Object)pmO.isPresent());
        if (this.meta.structure().isCompoundPK()) {
            return this.generateWhereClauseForSelectWithCompound(pmO, from);
        }
        return from.where(QueryBuilder.eq((String)this.meta.getCQLColumnName(), (Object)QueryBuilder.bindMarker((String)this.meta.getCQLColumnName())));
    }

    private Select.Where generateWhereClauseForSelectWithCompound(Optional<PropertyMeta> pmO, Select from) {
        log.debug("Generate SELECT WHERE clause with compound primary key for property meta {} with static column ? {}", (Object)this.meta, (Object)pmO.isPresent());
        Select.Where where = null;
        int i = 0;
        List<String> componentNames = pmO.isPresent() && ((PropertyMeta)pmO.get()).structure().isStaticColumn() ? this.meta.getCompoundPKProperties().getPartitionComponents().getCQLComponentNames() : this.meta.getCompoundPKProperties().getCQLComponentNames();
        for (String partitionKey : componentNames) {
            if (i++ == 0) {
                where = from.where(QueryBuilder.eq((String)partitionKey, (Object)QueryBuilder.bindMarker((String)partitionKey)));
                continue;
            }
            where.and(QueryBuilder.eq((String)partitionKey, (Object)QueryBuilder.bindMarker((String)partitionKey)));
        }
        return where;
    }

    public RegularStatement generateWhereClauseForDelete(boolean onlyStaticColumns, Delete mainFrom) {
        log.debug("Generate DELETE WHERE clause for property meta {} with static column ? {}", (Object)this.meta, (Object)onlyStaticColumns);
        if (this.meta.structure().isCompoundPK()) {
            return this.generateWhereClauseForDeleteWithCompound(onlyStaticColumns, mainFrom);
        }
        return mainFrom.where(QueryBuilder.eq((String)this.meta.getCQLColumnName(), (Object)QueryBuilder.bindMarker((String)this.meta.getCQLColumnName())));
    }

    private Delete.Where generateWhereClauseForDeleteWithCompound(boolean onlyStaticColumns, Delete mainFrom) {
        log.debug("Generate DELETE WHERE clause with compound primary key for property meta {} with static column ? {}", (Object)this.meta, (Object)onlyStaticColumns);
        Delete.Where where = null;
        List<String> componentNames = onlyStaticColumns ? this.meta.getCompoundPKProperties().getPartitionComponents().getCQLComponentNames() : this.meta.getCompoundPKProperties().getCQLComponentNames();
        int i = 0;
        for (String clusteredId : componentNames) {
            if (i++ == 0) {
                where = mainFrom.where(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
                continue;
            }
            where.and(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
        }
        return where;
    }

    public Update.Assignments prepareUpdateField(Update.Conditions updateConditions) {
        log.debug("Prepare UPDATE clause for property meta {} ", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return updateConditions.with(QueryBuilder.set((String)cqlColumnName, (Object)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments prepareUpdateField(Update.Assignments assignments) {
        log.debug("Prepare UPDATE clause for property meta {} ", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return assignments.and(QueryBuilder.set((String)cqlColumnName, (Object)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Where prepareCommonWhereClauseForUpdate(Update.Assignments assignments, boolean onlyStaticColumns) {
        log.debug("Prepare common UPDATE WHERE clause for property meta {} with static column ? {}", (Object)this.meta, (Object)onlyStaticColumns);
        if (this.meta.structure().isCompoundPK()) {
            return this.prepareCommonWhereClauseForUpdateWithCompound(assignments, onlyStaticColumns);
        }
        String cqlColumnName = this.meta.getCQLColumnName();
        return assignments.where(QueryBuilder.eq((String)cqlColumnName, (Object)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    private Update.Where prepareCommonWhereClauseForUpdateWithCompound(Update.Assignments assignments, boolean onlyStaticColumns) {
        log.debug("Prepare common UPDATE WHERE clause with compound primary key for property meta {} with static column ? {}", (Object)this.meta, (Object)onlyStaticColumns);
        Update.Where where = null;
        int i = 0;
        if (onlyStaticColumns) {
            for (String partitionKeys : this.meta.getCompoundPKProperties().getPartitionComponents().getCQLComponentNames()) {
                if (i++ == 0) {
                    where = assignments.where(QueryBuilder.eq((String)partitionKeys, (Object)QueryBuilder.bindMarker((String)partitionKeys)));
                    continue;
                }
                where.and(QueryBuilder.eq((String)partitionKeys, (Object)QueryBuilder.bindMarker((String)partitionKeys)));
            }
        } else {
            for (String clusteredId : this.meta.getCompoundPKProperties().getCQLComponentNames()) {
                if (i++ == 0) {
                    where = assignments.where(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
                    continue;
                }
                where.and(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
            }
        }
        return where;
    }

    public Pair<Update.Where, Object[]> generateWhereClauseForUpdate(Object entity, PropertyMeta pm, Update.Assignments update) {
        log.debug("Generate plain UPDATE WHERE clause for property meta {}", (Object)pm);
        Object primaryKey = this.meta.forValues().getPrimaryKey(entity);
        if (this.meta.structure().isCompoundPK()) {
            return this.generateWhereClauseForUpdateWithCompound(primaryKey, pm, update);
        }
        Object id = this.meta.forTranscoding().encodeToCassandra(primaryKey);
        Update.Where where = update.where(QueryBuilder.eq((String)this.meta.getCQLColumnName(), id));
        Object[] boundValues = new Object[]{id};
        return Pair.create(where, boundValues);
    }

    private Pair<Update.Where, Object[]> generateWhereClauseForUpdateWithCompound(Object primaryKey, PropertyMeta pm, Update.Assignments update) {
        log.debug("Generate plain UPDATE WHERE clause with compound primary key for property meta {}", (Object)pm);
        List<String> componentNames = this.meta.getCompoundPKProperties().getCQLComponentNames();
        List<Object> encodedComponents = this.meta.forTranscoding().encodeToComponents(primaryKey, pm.structure().isStaticColumn());
        Object[] boundValues = new Object[encodedComponents.size()];
        Update.Where where = null;
        for (int i = 0; i < encodedComponents.size(); ++i) {
            String componentName = componentNames.get(i);
            Object componentValue = encodedComponents.get(i);
            if (i == 0) {
                where = update.where(QueryBuilder.eq((String)componentName, (Object)componentValue));
            } else {
                where.and(QueryBuilder.eq((String)componentName, (Object)componentValue));
            }
            boundValues[i] = componentValue;
        }
        return Pair.create(where, boundValues);
    }

    public Select.Selection prepareSelectField(Select.Selection select) {
        log.debug("Prepare SELECT clause for property meta {}", (Object)this.meta);
        if (this.meta.structure().isCompoundPK()) {
            for (String component : this.meta.getCompoundPKProperties().getCQLComponentNames()) {
                select = select.column(component);
            }
            return select;
        }
        return select.column(this.meta.getCQLColumnName());
    }

    public Update.Assignments generateUpdateForRemoveAll(Update.Conditions conditions) {
        log.debug("Generate UPDATE for changing collection for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.set((String)cqlColumnName, (Object)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments generateUpdateForAddedElements(Update.Conditions conditions) {
        log.debug("Generate UPDATE for adding elements to collection for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.addAll((String)cqlColumnName, (BindMarker)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments generateUpdateForRemovedElements(Update.Conditions conditions) {
        log.debug("Generate UPDATE for removing all elements from collection for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.removeAll((String)cqlColumnName, (BindMarker)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments generateUpdateForAppendedElements(Update.Conditions conditions) {
        log.debug("Generate UPDATE for appending elements to collection for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.appendAll((String)cqlColumnName, (BindMarker)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments generateUpdateForPrependedElements(Update.Conditions conditions) {
        log.debug("Generate UPDATE for prepending elements to collection for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.prependAll((String)cqlColumnName, (BindMarker)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments generateUpdateForRemoveListElements(Update.Conditions conditions) {
        log.debug("Generate UPDATE for discarding all elements from list for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.discardAll((String)cqlColumnName, (BindMarker)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments generateUpdateForAddedEntries(Update.Conditions conditions) {
        log.debug("Generate UPDATE for adding entries to map for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.putAll((String)cqlColumnName, (BindMarker)QueryBuilder.bindMarker((String)cqlColumnName)));
    }

    public Update.Assignments generateUpdateForRemovedKey(Update.Conditions conditions) {
        log.debug("Generate UPDATE for removing from map by key for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.put((String)cqlColumnName, (Object)QueryBuilder.bindMarker((String)"key"), (Object)QueryBuilder.bindMarker((String)"nullValue")));
    }

    public Update.Assignments generateUpdateForSetAtIndexElement(Update.Conditions conditions, int index, Object encoded) {
        log.debug("Generate UPDATE for setting list element at index for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.setIdx((String)cqlColumnName, (int)index, (Object)encoded));
    }

    public Update.Assignments generateUpdateForRemovedAtIndexElement(Update.Conditions conditions, int index) {
        log.debug("Generate UPDATE for removing list element at index for property meta {}", (Object)this.meta);
        String cqlColumnName = this.meta.getCQLColumnName();
        return conditions.with(QueryBuilder.setIdx((String)cqlColumnName, (int)index, null));
    }
}

