/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaView;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.type.IndexCondition;
import java.util.List;

public class EntityMetaTranscoder
extends EntityMetaView {
    protected EntityMetaTranscoder(EntityMeta meta) {
        super(meta);
    }

    public Object encodeCasConditionValue(Options.LWTCondition LWTCondition2) {
        Object rawValue = LWTCondition2.getValue();
        String columnName = LWTCondition2.getColumnName();
        Object encodedValue = this.encodeValueForProperty(columnName, rawValue);
        LWTCondition2.encodedValue(encodedValue);
        return encodedValue;
    }

    public Object encodeIndexConditionValue(IndexCondition indexCondition) {
        Object rawValue = indexCondition.getColumnValue();
        String columnName = indexCondition.getColumnName();
        Object encodedValue = this.encodeValueForProperty(columnName, rawValue);
        indexCondition.encodedValue(encodedValue);
        return encodedValue;
    }

    public List<Object> encodePartitionComponents(List<Object> rawPartitionComponents) {
        return this.meta.getIdMeta().forTranscoding().encodePartitionComponents(rawPartitionComponents);
    }

    public List<Object> encodePartitionComponentsIN(List<Object> rawPartitionComponentsIN) {
        return this.meta.getIdMeta().forTranscoding().encodePartitionComponentsIN(rawPartitionComponentsIN);
    }

    public List<Object> encodeClusteringKeys(List<Object> rawClusteringKeys) {
        return this.meta.getIdMeta().forTranscoding().encodeClusteringKeys(rawClusteringKeys);
    }

    public List<Object> encodeClusteringKeysIN(List<Object> rawClusteringKeysIN) {
        return this.meta.getIdMeta().forTranscoding().encodeClusteringKeysIN(rawClusteringKeysIN);
    }

    private Object encodeValueForProperty(String columnName, Object rawValue) {
        Object encodedValue = rawValue;
        if (rawValue != null) {
            PropertyMeta propertyMeta = this.findPropertyMetaByCQLName(columnName);
            encodedValue = propertyMeta.forTranscoding().encodeToCassandra(rawValue);
        }
        return encodedValue;
    }

    PropertyMeta findPropertyMetaByCQLName(String cqlName) {
        for (PropertyMeta propertyMeta : this.meta.getAllMetasExceptCounters()) {
            if (propertyMeta.type() == PropertyType.COMPOUND_PRIMARY_KEY) {
                for (PropertyMeta partitionMeta : propertyMeta.getCompoundPKProperties().getPartitionComponents().getPropertyMetas()) {
                    if (!partitionMeta.getCQLColumnName().equals(cqlName)) continue;
                    return partitionMeta;
                }
                for (PropertyMeta clusteringMeta : propertyMeta.getCompoundPKProperties().getClusteringComponents().getPropertyMetas()) {
                    if (!clusteringMeta.getCQLColumnName().equals(cqlName)) continue;
                    return clusteringMeta;
                }
                continue;
            }
            if (!propertyMeta.getCQLColumnName().equals(cqlName)) continue;
            return propertyMeta;
        }
        throw new AchillesException(String.format("Cannot find matching property meta for the cql field %s", cqlName));
    }
}

