/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.utils.Pair;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMetaBuilder {
    private static final Logger log = LoggerFactory.getLogger(EntityMetaBuilder.class);
    private PropertyMeta idMeta;
    private Class<?> entityClass;
    private String className;
    private String keyspaceName;
    private String tableName;
    private String tableComment;
    private Map<String, PropertyMeta> propertyMetas;
    private Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels;
    private InsertStrategy insertStrategy;
    private boolean schemaUpdateEnabled;

    public static EntityMetaBuilder entityMetaBuilder(PropertyMeta idMeta) {
        return new EntityMetaBuilder(idMeta);
    }

    public EntityMetaBuilder(PropertyMeta idMeta) {
        this.idMeta = idMeta;
    }

    public EntityMeta build() {
        log.debug("Build entityMeta for entity class {}", (Object)this.className);
        Validator.validateNotNull(this.idMeta, "idMeta should not be null for entity meta creation", new Object[0]);
        Validator.validateNotEmpty(this.propertyMetas, "propertyMetas map should not be empty for entity meta creation", new Object[0]);
        EntityMeta meta = new EntityMeta();
        meta.setIdMeta(this.idMeta);
        meta.setIdClass(this.idMeta.getValueClass());
        meta.setEntityClass(this.entityClass);
        meta.setClassName(this.className);
        meta.setKeyspaceName(this.keyspaceName);
        meta.setTableName(this.tableName);
        meta.setQualifiedTableName(this.keyspaceName + "." + this.tableName);
        meta.setTableComment(this.tableComment);
        meta.setPropertyMetas(Collections.unmodifiableMap(this.propertyMetas));
        meta.setGetterMetas(Collections.unmodifiableMap(this.extractGetterMetas(this.propertyMetas)));
        meta.setSetterMetas(Collections.unmodifiableMap(this.extractSetterMetas(this.propertyMetas)));
        meta.setConsistencyLevels(this.consistencyLevels);
        meta.setInsertStrategy(this.insertStrategy);
        meta.setSchemaUpdateEnabled(this.schemaUpdateEnabled);
        ArrayList<PropertyMeta> allMetasExceptId = new ArrayList<PropertyMeta>((Collection<PropertyMeta>)FluentIterable.from(this.propertyMetas.values()).filter((Predicate)PropertyType.EXCLUDE_ID_TYPES).toList());
        meta.setAllMetasExceptId(allMetasExceptId);
        ArrayList<PropertyMeta> allMetasExceptIdAndCounters = new ArrayList<PropertyMeta>((Collection<PropertyMeta>)FluentIterable.from(this.propertyMetas.values()).filter((Predicate)PropertyType.EXCLUDE_PK_AND_COUNTER_TYPE).toList());
        meta.setAllMetasExceptIdAndCounters(allMetasExceptIdAndCounters);
        ArrayList<PropertyMeta> allMetasExceptCounters = new ArrayList<PropertyMeta>((Collection<PropertyMeta>)FluentIterable.from(this.propertyMetas.values()).filter((Predicate)PropertyType.EXCLUDE_COUNTER_TYPE).toList());
        meta.setAllMetasExceptCounters(allMetasExceptCounters);
        boolean clusteredEntity = this.idMeta.structure().isCompoundPK() && this.idMeta.structure().isClustered();
        meta.setClusteredEntity(clusteredEntity);
        boolean clusteredCounter = allMetasExceptId.size() > 0;
        for (PropertyMeta pm : allMetasExceptId) {
            if (pm.structure().isCounter()) continue;
            clusteredCounter = false;
            break;
        }
        meta.setClusteredCounter(clusteredCounter);
        int staticColumnsCount = FluentIterable.from(allMetasExceptId).filter(PropertyMeta.STATIC_COLUMN_FILTER).size();
        if (staticColumnsCount > 0) {
            meta.setHasStaticColumns(true);
            if (staticColumnsCount == allMetasExceptId.size()) {
                meta.setHasOnlyStaticColumns(true);
            }
        }
        return meta;
    }

    private Map<Method, PropertyMeta> extractGetterMetas(Map<String, PropertyMeta> propertyMetas) {
        HashMap<Method, PropertyMeta> getterMetas = new HashMap<Method, PropertyMeta>();
        for (PropertyMeta propertyMeta : propertyMetas.values()) {
            getterMetas.put(propertyMeta.getGetter(), propertyMeta);
        }
        return getterMetas;
    }

    private Map<Method, PropertyMeta> extractSetterMetas(Map<String, PropertyMeta> propertyMetas) {
        HashMap<Method, PropertyMeta> setterMetas = new HashMap<Method, PropertyMeta>();
        for (PropertyMeta propertyMeta : propertyMetas.values()) {
            setterMetas.put(propertyMeta.getSetter(), propertyMeta);
        }
        return setterMetas;
    }

    public EntityMetaBuilder entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public EntityMetaBuilder className(String className) {
        this.className = className;
        return this;
    }

    public EntityMetaBuilder keyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
        return this;
    }

    public EntityMetaBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public EntityMetaBuilder tableComment(String tableComment) {
        this.tableComment = tableComment;
        return this;
    }

    public EntityMetaBuilder propertyMetas(Map<String, PropertyMeta> propertyMetas) {
        this.propertyMetas = propertyMetas;
        return this;
    }

    public EntityMetaBuilder consistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        this.consistencyLevels = consistencyLevels;
        return this;
    }

    public EntityMetaBuilder insertStrategy(InsertStrategy insertStrategy) {
        this.insertStrategy = insertStrategy;
        return this;
    }

    public EntityMetaBuilder schemaUpdateEnabled(boolean value) {
        this.schemaUpdateEnabled = value;
        return this;
    }
}

