/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.metadata.holder.AbstractComponentProperties;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringComponents
extends AbstractComponentProperties {
    private static final Logger log = LoggerFactory.getLogger(ClusteringComponents.class);
    private List<Create.Options.ClusteringOrder> clusteringOrders;

    public ClusteringComponents(List<PropertyMeta> clusteringKeyMetas, List<Create.Options.ClusteringOrder> clusteringOrders) {
        super(clusteringKeyMetas);
        this.clusteringOrders = clusteringOrders;
    }

    void validateClusteringComponents(String className, Object ... clusteringComponentsArray) {
        Validator.validateTrue(ArrayUtils.isNotEmpty((Object[])clusteringComponentsArray), "There should be at least one clustering key provided for querying on entity '%s'", className);
        List<Object> clusteringComponents = Arrays.asList(clusteringComponentsArray);
        log.trace("Validate clustering components {} for slice query on entity class {}", clusteringComponents, (Object)className);
        List<Class<?>> componentClasses = this.getComponentClasses();
        int maxClusteringCount = componentClasses.size();
        Validator.validateTrue(clusteringComponents.size() <= maxClusteringCount, "There should be at most %s value(s) of clustering component(s) provided for querying on entity '%s'", maxClusteringCount, className);
        for (int i = 0; i < clusteringComponents.size(); ++i) {
            Object clusteringKey = clusteringComponents.get(i);
            Validator.validateNotNull(clusteringKey, "The '%sth' clustering key should not be null", i + 1);
            Class<?> currentClusteringType = clusteringKey.getClass();
            Class<?> expectedClusteringType = componentClasses.get(i);
            Validator.validateTrue(ClusteringComponents.isCompatibleClass(expectedClusteringType, currentClusteringType), "The type '%s' of clustering key '%s' for querying on entity '%s' is not valid. It should be '%s'", currentClusteringType.getCanonicalName(), clusteringKey, className, expectedClusteringType.getCanonicalName());
        }
    }

    void validateClusteringComponentsIn(String className, Object ... clusteringComponentsInArray) {
        List<Class<?>> componentClasses = this.getComponentClasses();
        Validator.validateTrue(ArrayUtils.isNotEmpty((Object[])clusteringComponentsInArray), "There should be at least one clustering key IN provided for querying on entity '%s'", className);
        List<Object> clusteringComponentsIn = Arrays.asList(clusteringComponentsInArray);
        log.trace("Validate clustering components IN {} for slice query on entity class {}", clusteringComponentsIn, (Object)className);
        Class<?> lastClusteringComponentType = componentClasses.get(componentClasses.size() - 1);
        for (int i = 0; i < clusteringComponentsIn.size(); ++i) {
            Object clusteringKey = clusteringComponentsIn.get(i);
            Validator.validateNotNull(clusteringKey, "The '%sth' clustering key should not be null", i + 1);
            Class<?> currentClusteringType = clusteringKey.getClass();
            Validator.validateTrue(ClusteringComponents.isCompatibleClass(lastClusteringComponentType, currentClusteringType), "The type '%s' of clustering key '%s' for querying on entity '%s' is not valid. It should be '%s'", currentClusteringType.getCanonicalName(), clusteringKey, className, lastClusteringComponentType.getCanonicalName());
        }
    }

    boolean isClustered() {
        return this.getComponentClasses().size() > 0;
    }

    public List<Create.Options.ClusteringOrder> getClusteringOrders() {
        return this.clusteringOrders;
    }
}

