/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.codec;

import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import info.archinnov.achilles.internal.metadata.codec.ListCodec;
import java.util.ArrayList;
import java.util.List;

public class ListCodecImpl<FROM, TO>
implements ListCodec<FROM, TO> {
    private final Class<FROM> sourceType;
    private final Class<TO> targetType;
    private final Codec<FROM, TO> valueCodec;

    public ListCodecImpl(Class<FROM> sourceType, Class<TO> targetType, Codec<FROM, TO> valueCodec) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.valueCodec = valueCodec;
    }

    @Override
    public Class<FROM> sourceType() {
        return this.sourceType;
    }

    @Override
    public Class<TO> targetType() {
        return this.targetType;
    }

    @Override
    public List<TO> encode(List<FROM> fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        ArrayList<Object> encoded = new ArrayList<Object>();
        for (FROM source : fromJava) {
            encoded.add(this.valueCodec.encode(source));
        }
        return encoded;
    }

    @Override
    public List<FROM> decode(List<TO> fromCassandra) throws AchillesTranscodingException {
        if (fromCassandra == null) {
            return null;
        }
        ArrayList<Object> decoded = new ArrayList<Object>();
        for (TO source : fromCassandra) {
            decoded.add(this.valueCodec.decode(source));
        }
        return decoded;
    }
}

