/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.interceptor;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.exception.AchillesBeanValidationException;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.interceptor.AchillesInternalInterceptor;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;

public class DefaultBeanValidationInterceptor
implements AchillesInternalInterceptor<Object> {
    private static final Set<String> ALWAYS_TRUE_CONTAINS_SET = new AlwaysTrueContainsSet();
    private static final Function<DirtyChecker, String> DIRTY_CHECKER_TO_FIELD_NAME = new Function<DirtyChecker, String>(){

        public String apply(DirtyChecker dirtyChecker) {
            return dirtyChecker.getPropertyMeta().getPropertyName();
        }
    };
    private Validator validator;
    protected EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();

    public DefaultBeanValidationInterceptor(Validator validator) {
        this.validator = validator;
    }

    public void onEvent(Object entity) {
        Set<String> dirtyFieldNames = this.getDirtyFiedNames(entity);
        Object realObject = this.proxifier.getRealObject(entity);
        Set violations = this.validator.validate(realObject, new Class[0]);
        boolean raiseError = false;
        if (violations.size() > 0) {
            StringBuilder errorMessage = new StringBuilder("Bean validation error : \n");
            for (ConstraintViolation violation : violations) {
                raiseError |= this.buildValidationErrorMessage(errorMessage, (ConstraintViolation<Object>)violation, dirtyFieldNames);
            }
            if (raiseError) {
                throw new AchillesBeanValidationException(errorMessage.toString());
            }
        }
    }

    private Set<String> getDirtyFiedNames(Object entity) {
        if (this.proxifier.isProxy(entity)) {
            Map<Method, DirtyChecker> dirtyMap = this.proxifier.getInterceptor(entity).getDirtyMap();
            return FluentIterable.from(dirtyMap.values()).transform(DIRTY_CHECKER_TO_FIELD_NAME).toSet();
        }
        return ALWAYS_TRUE_CONTAINS_SET;
    }

    private boolean buildValidationErrorMessage(StringBuilder errorMessage, ConstraintViolation<Object> violation, Set<String> dirtyFieldNames) {
        String className = violation.getLeafBean().getClass().getCanonicalName();
        Path propertyPath = violation.getPropertyPath();
        ElementKind elementKind = ((Path.Node)propertyPath.iterator().next()).getKind();
        String propertyName = propertyPath.toString();
        boolean raiseError = false;
        if (dirtyFieldNames.contains(propertyName) || elementKind != ElementKind.PROPERTY) {
            errorMessage.append("\t");
            raiseError = true;
            if (propertyPath != null && StringUtils.isNotBlank((CharSequence)propertyPath.toString())) {
                errorMessage.append("property '").append(propertyPath).append("'").append(" of class '").append(className).append("' ").append(violation.getMessage()).append("\n");
            } else {
                errorMessage.append(violation.getMessage()).append(" for class '").append(className).append("'");
            }
        }
        return raiseError;
    }

    public List<Event> events() {
        return Arrays.asList(Event.PRE_INSERT, Event.PRE_UPDATE);
    }

    private static class AlwaysTrueContainsSet
    implements Set<String> {
        private AlwaysTrueContainsSet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return null;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }

        @Override
        public boolean add(String s) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }
    }
}

