/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.consistency;

import com.datastax.driver.core.ConsistencyLevel;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyConverter {
    private static final Logger log = LoggerFactory.getLogger(ConsistencyConverter.class);
    private static final Map<info.archinnov.achilles.type.ConsistencyLevel, ConsistencyLevel> fromAchillesToCQL = new HashMap<info.archinnov.achilles.type.ConsistencyLevel, ConsistencyLevel>();

    public static ConsistencyLevel getCQLLevel(info.archinnov.achilles.type.ConsistencyLevel achillesLevel) {
        log.trace("Convert Achilles Consistency Level to CQL Consistency Level");
        ConsistencyLevel cqlLevel = fromAchillesToCQL.get(achillesLevel);
        if (cqlLevel == null) {
            throw new IllegalArgumentException("No matching Consistency Level for Achilles level '" + (achillesLevel != null ? achillesLevel.name() : "null") + "'");
        }
        return cqlLevel;
    }

    static {
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.ANY, ConsistencyLevel.ANY);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.ONE, ConsistencyLevel.ONE);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.TWO, ConsistencyLevel.TWO);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.THREE, ConsistencyLevel.THREE);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.QUORUM, ConsistencyLevel.QUORUM);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.LOCAL_QUORUM);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.EACH_QUORUM, ConsistencyLevel.EACH_QUORUM);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.ALL, ConsistencyLevel.ALL);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.SERIAL, ConsistencyLevel.SERIAL);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.LOCAL_SERIAL, ConsistencyLevel.LOCAL_SERIAL);
        fromAchillesToCQL.put(info.archinnov.achilles.type.ConsistencyLevel.LOCAL_ONE, ConsistencyLevel.LOCAL_ONE);
    }
}

