/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.async;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import info.archinnov.achilles.exception.AchillesBeanValidationException;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.exception.AchillesInvalidTableException;
import info.archinnov.achilles.exception.AchillesLightWeightTransactionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AchillesFuture<V>
implements ListenableFuture<V> {
    private final ListenableFuture<V> delegate;

    public AchillesFuture(ListenableFuture<V> delegate) {
        this.delegate = delegate;
    }

    public V getImmediately() {
        try {
            return (V)Uninterruptibles.getUninterruptibly(this.delegate);
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.delegate.get();
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.delegate.get(timeout, unit);
    }

    private RuntimeException extractCauseFromExecutionException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof DriverException) {
            return ((DriverException)cause).copy();
        }
        if (cause instanceof DriverInternalError) {
            return (DriverInternalError)cause;
        }
        if (cause instanceof AchillesLightWeightTransactionException) {
            return (AchillesLightWeightTransactionException)cause;
        }
        if (cause instanceof AchillesBeanValidationException) {
            return (AchillesBeanValidationException)cause;
        }
        if (cause instanceof AchillesInvalidTableException) {
            return (AchillesInvalidTableException)cause;
        }
        if (cause instanceof AchillesException) {
            return (AchillesException)cause;
        }
        return new AchillesException(cause);
    }
}

