/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.jmx;

import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class MBeanServerDelegate
implements MBeanServer {
    private final Kernel kernel;

    public MBeanServerDelegate(Kernel kernel) {
        this.kernel = kernel;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            return this.kernel.getAttribute(name, attribute);
        }
        catch (NoSuchAttributeException e) {
            throw new AttributeNotFoundException(attribute);
        }
        catch (GBeanNotFoundException e) {
            throw new InstanceNotFoundException(name.getCanonicalName());
        }
        catch (InternalKernelException e) {
            throw new MBeanException(MBeanServerDelegate.unwrapInternalKernelException(e));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            String attribute = attributes[i];
            try {
                Object value = this.kernel.getAttribute(name, attribute);
                attributeList.add(i, new Attribute(attribute, value));
                continue;
            }
            catch (NoSuchAttributeException e) {
                continue;
            }
            catch (GBeanNotFoundException e) {
                throw new InstanceNotFoundException(name.getCanonicalName());
            }
            catch (InternalKernelException e) {
                throw new ReflectionException(MBeanServerDelegate.unwrapInternalKernelException(e));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attributeList;
    }

    public String getDefaultDomain() {
        return this.kernel.getKernelName();
    }

    public Integer getMBeanCount() {
        return new Integer(this.kernel.listGBeans((ObjectName)null).size());
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, ReflectionException {
        GBeanInfo gbeanInfo;
        try {
            gbeanInfo = this.kernel.getGBeanInfo(name);
        }
        catch (GBeanNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (InternalKernelException e) {
            throw new ReflectionException(MBeanServerDelegate.unwrapInternalKernelException(e));
        }
        return JMXUtil.toMBeanInfo(gbeanInfo);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            return this.kernel.invoke(name, operationName, params, signature);
        }
        catch (NoSuchOperationException e) {
            throw new ReflectionException(new NoSuchMethodException(e.getMessage()));
        }
        catch (GBeanNotFoundException e) {
            if (name.equals(e.getGBeanName())) {
                throw new InstanceNotFoundException(name.getCanonicalName());
            }
            throw new MBeanException(e);
        }
        catch (InternalKernelException e) {
            throw new MBeanException(MBeanServerDelegate.unwrapInternalKernelException(e));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public boolean isRegistered(ObjectName name) {
        return this.kernel.isLoaded(name);
    }

    public Set queryNames(ObjectName pattern, QueryExp query) {
        Set names = this.kernel.listGBeans(pattern);
        if (query == null) {
            return names;
        }
        HashSet<ObjectName> filteredNames = new HashSet<ObjectName>(names.size());
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            query.setMBeanServer(this);
            ObjectName name = (ObjectName)iterator.next();
            try {
                if (!query.apply(name)) continue;
                filteredNames.add(name);
            }
            catch (Exception e) {}
        }
        return filteredNames;
    }

    public Set queryMBeans(ObjectName pattern, QueryExp query) {
        Set names = this.queryNames(pattern, query);
        HashSet<ObjectInstance> objectInstances = new HashSet<ObjectInstance>(names.size());
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            ObjectName name = (ObjectName)iterator.next();
            try {
                objectInstances.add(this.getObjectInstance(name));
            }
            catch (InstanceNotFoundException e) {}
        }
        return objectInstances;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException {
        String attributeName = attribute.getName();
        Object attributeValue = attribute.getValue();
        try {
            this.kernel.setAttribute(name, attributeName, attributeValue);
        }
        catch (NoSuchAttributeException e) {
            throw new AttributeNotFoundException(attributeName);
        }
        catch (GBeanNotFoundException e) {
            throw new InstanceNotFoundException(name.getCanonicalName());
        }
        catch (InternalKernelException e) {
            throw new MBeanException(MBeanServerDelegate.unwrapInternalKernelException(e));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList set = new AttributeList(attributes.size());
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String attributeName = attribute.getName();
            Object attributeValue = attribute.getValue();
            try {
                this.kernel.setAttribute(name, attributeName, attributeValue);
                set.add(attribute);
            }
            catch (NoSuchAttributeException e) {
            }
            catch (GBeanNotFoundException e) {
                throw new InstanceNotFoundException(name.getCanonicalName());
            }
            catch (InternalKernelException e) {
                throw new ReflectionException(MBeanServerDelegate.unwrapInternalKernelException(e));
            }
            catch (Exception e) {
            }
        }
        return set;
    }

    public String[] getDomains() {
        HashSet<String> domains = new HashSet<String>();
        Set names = this.kernel.listGBeans((ObjectName)null);
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            domains.add(objectName.getDomain());
        }
        return domains.toArray(new String[domains.size()]);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        try {
            GBeanInfo gbeanInfo = this.kernel.getGBeanInfo(objectName);
            return new ObjectInstance(objectName, gbeanInfo.getClassName());
        }
        catch (GBeanNotFoundException e) {
            throw new InstanceNotFoundException(objectName.getCanonicalName());
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        try {
            return this.kernel.getClassLoaderFor(objectName);
        }
        catch (GBeanNotFoundException e) {
            throw new InstanceNotFoundException(objectName.getCanonicalName());
        }
    }

    private static Exception unwrapInternalKernelException(InternalKernelException e) {
        if (e.getCause() instanceof Exception) {
            return (Exception)e.getCause();
        }
        return e;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public boolean isInstanceOf(ObjectName objectName, String s) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName, ObjectName objectName1) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName, Object[] objects, String[] strings) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName, ObjectName objectName1, Object[] objects, String[] strings) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s) throws ReflectionException, MBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s, Object[] objects, String[] strings) throws ReflectionException, MBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s, ObjectName objectName, Object[] objects, String[] strings) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance registerMBean(Object o, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInputStream deserialize(String s, ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInputStream deserialize(String s, byte[] bytes) throws OperationsException, ReflectionException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException {
        throw new SecurityException("Operation not allowed");
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return new ClassLoaderRepository(){

            public Class loadClass(String className) throws ClassNotFoundException {
                throw new ClassNotFoundException(className);
            }

            public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
                throw new ClassNotFoundException(className);
            }

            public Class loadClassBefore(ClassLoader loader, String className) throws ClassNotFoundException {
                throw new ClassNotFoundException(className);
            }
        };
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        throw new SecurityException("Operation not allowed");
    }
}

