/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.beans.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.config.ConfigurationClassLoader;

public class MultiParentClassLoader
extends URLClassLoader {
    private final URI id;
    private final ClassLoader[] parents;
    private final boolean inverseClassLoading;
    private final String[] hiddenClasses;
    private final String[] nonOverridableClasses;
    private static Object lock = new Object();
    private static boolean clearSoftCacheFailed = false;

    public MultiParentClassLoader(URI id, URL[] urls) {
        super(urls);
        this.id = id;
        this.parents = new ClassLoader[0];
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
    }

    public MultiParentClassLoader(URI id, URL[] urls, ClassLoader parent) {
        this(id, urls, new ClassLoader[]{parent});
    }

    public MultiParentClassLoader(URI id, URL[] urls, ClassLoader parent, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        this(id, urls, new ClassLoader[]{parent}, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public MultiParentClassLoader(URI id, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(id, urls, new ClassLoader[]{parent}, factory);
    }

    public MultiParentClassLoader(URI id, URL[] urls, ClassLoader[] parents) {
        super(urls);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
    }

    public MultiParentClassLoader(URI id, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(urls, (ClassLoader)new FilteringParentCL(hiddenClasses));
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = inverseClassLoading;
        this.hiddenClasses = hiddenClasses;
        this.nonOverridableClasses = nonOverridableClasses;
    }

    public MultiParentClassLoader(URI id, URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(urls, null, factory);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
    }

    private static ClassLoader[] copyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    public URI getId() {
        return this.id;
    }

    public ClassLoader[] getParents() {
        return this.parents;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i;
        Class<?> clazz = this.findLoadedClass(name);
        if (null != clazz) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.inverseClassLoading) {
            boolean checkMe = true;
            for (i = 0; i < this.nonOverridableClasses.length && checkMe; ++i) {
                if (!name.startsWith(this.nonOverridableClasses[i])) continue;
                checkMe = false;
            }
            if (checkMe) {
                try {
                    clazz = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
        boolean checkParents = true;
        for (i = 0; i < this.hiddenClasses.length && checkParents; ++i) {
            if (!name.startsWith(this.hiddenClasses[i])) continue;
            checkParents = false;
        }
        if (checkParents) {
            for (i = 0; i < this.parents.length && clazz == null; ++i) {
                ClassLoader parent = this.parents[i];
                try {
                    clazz = parent.loadClass(name);
                    continue;
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
        if (null == clazz) {
            return super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public URL getResource(String name) {
        URL url = null;
        if (this.inverseClassLoading && null != (url = super.getResource(name))) {
            return url;
        }
        for (int i = 0; i < this.parents.length && url == null; ++i) {
            ClassLoader parent = this.parents[i];
            url = parent.getResource(name);
        }
        if (url == null && !this.inverseClassLoading) {
            return super.getResource(name);
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader parent = this.parents[i];
            ArrayList<URL> parentResources = Collections.list(parent.getResources(name));
            resources.addAll(parentResources);
        }
        ArrayList<URL> myResources = Collections.list(super.findResources(name));
        resources.addAll(myResources);
        return Collections.enumeration(resources);
    }

    public String toString() {
        return "[" + this.getClass().getName() + " id=" + this.id + "]";
    }

    public void destroy() {
        LogFactory.release((ClassLoader)this);
        MultiParentClassLoader.clearSoftCache(ObjectInputStream.class, "subclassAudits");
        MultiParentClassLoader.clearSoftCache(ObjectOutputStream.class, "subclassAudits");
        MultiParentClassLoader.clearSoftCache(ObjectStreamClass.class, "localDescs");
        MultiParentClassLoader.clearSoftCache(ObjectStreamClass.class, "reflectors");
        Introspector.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearSoftCache(Class clazz, String fieldName) {
        Map cache = null;
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            cache = (Map)f.get(null);
        }
        catch (Throwable e) {
            Object object = lock;
            synchronized (object) {
                if (!clearSoftCacheFailed) {
                    clearSoftCacheFailed = true;
                    LogFactory.getLog((Class)ConfigurationClassLoader.class).error((Object)("Unable to clear SoftCache field " + fieldName + " in class " + clazz));
                }
            }
        }
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    private static class FilteringParentCL
    extends ClassLoader {
        private final String[] hiddenClasses;

        public FilteringParentCL(String[] hiddenClasses) {
            this.hiddenClasses = hiddenClasses;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            boolean checkParents = true;
            for (int i = 0; i < this.hiddenClasses.length && checkParents; ++i) {
                if (!name.startsWith(this.hiddenClasses[i])) continue;
                checkParents = false;
            }
            if (checkParents) {
                return super.loadClass(name, resolve);
            }
            throw new ClassNotFoundException(name);
        }
    }
}

