/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanName;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;

public class BasicRegistry {
    private final Map registry = new HashMap();
    private String kernelName = "";

    public void start(Kernel kernel) {
        this.kernelName = kernel.getKernelName();
    }

    public synchronized void stop() {
        this.registry.clear();
        this.kernelName = "";
    }

    public synchronized boolean isRegistered(GBeanName name) {
        return this.registry.containsKey(name);
    }

    public synchronized void register(GBeanInstance gbeanInstance) throws GBeanAlreadyExistsException {
        GBeanName name = this.createGBeanName(gbeanInstance.getObjectNameObject());
        if (this.registry.containsKey(name)) {
            throw new GBeanAlreadyExistsException("GBean already registered: " + name);
        }
        this.registry.put(name, gbeanInstance);
    }

    public synchronized void unregister(GBeanName name) throws GBeanNotFoundException, InternalKernelException {
        if (this.registry.remove(name) == null) {
            try {
                throw new GBeanNotFoundException(name.getObjectName());
            }
            catch (MalformedObjectNameException e) {
                throw new InternalKernelException(e);
            }
        }
    }

    public synchronized GBeanInstance getGBeanInstance(GBeanName name) throws GBeanNotFoundException {
        GBeanInstance instance = (GBeanInstance)this.registry.get(name);
        if (instance == null) {
            try {
                throw new GBeanNotFoundException(name.getObjectName());
            }
            catch (MalformedObjectNameException e) {
                throw new InternalKernelException(e);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listGBeans(String domain, Map properties) {
        HashMap clone;
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            clone = new HashMap(this.registry);
        }
        HashSet result = new HashSet(clone.size());
        Iterator i = clone.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            GBeanName name = (GBeanName)entry.getKey();
            if (!name.matches(domain, properties)) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    private GBeanName createGBeanName(ObjectName objectName) {
        if (objectName.getDomain().length() == 0) {
            return new GBeanName(this.kernelName, objectName.getKeyPropertyList());
        }
        return new GBeanName(objectName);
    }
}

