/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;

public class BasicLifecycleMonitor
implements LifecycleMonitor {
    private static final Log log = LogFactory.getLog((Class)BasicLifecycleMonitor.class);
    private final Kernel kernel;
    private final Map boundListeners = new HashMap();
    private final Map listenerPatterns = new HashMap();

    public BasicLifecycleMonitor(Kernel kernel) {
        this.kernel = kernel;
        Set names = this.kernel.listGBeans((ObjectName)null);
        Iterator objectNameIterator = names.iterator();
        while (objectNameIterator.hasNext()) {
            this.addSource((ObjectName)objectNameIterator.next());
        }
    }

    public synchronized void destroy() {
        this.boundListeners.clear();
        this.listenerPatterns.clear();
    }

    private synchronized void addSource(ObjectName source) {
        if (this.boundListeners.containsKey(source)) {
            return;
        }
        HashSet<LifecycleListener> listeners = new HashSet<LifecycleListener>();
        Iterator listenerIterator = this.listenerPatterns.entrySet().iterator();
        while (listenerIterator.hasNext()) {
            Map.Entry entry = listenerIterator.next();
            Set patterns = (Set)entry.getValue();
            Iterator patternIterator = patterns.iterator();
            while (patternIterator.hasNext()) {
                ObjectName pattern = (ObjectName)patternIterator.next();
                if (!pattern.apply(source)) continue;
                LifecycleListener listener = (LifecycleListener)entry.getKey();
                listeners.add(listener);
            }
        }
        this.boundListeners.put(source, listeners);
    }

    private synchronized void removeSource(ObjectName source) {
        this.boundListeners.remove(source);
    }

    public synchronized void addLifecycleListener(LifecycleListener listener, ObjectName pattern) {
        this.addLifecycleListener(listener, Collections.singleton(pattern));
    }

    public synchronized void addLifecycleListener(LifecycleListener listener, Set patterns) {
        Iterator patternIterator = patterns.iterator();
        while (patternIterator.hasNext()) {
            ObjectName pattern = (ObjectName)patternIterator.next();
            Iterator iterator = this.boundListeners.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ObjectName source = (ObjectName)entry.getKey();
                if (!pattern.apply(source)) continue;
                Set listeners = (Set)entry.getValue();
                listeners.add(listener);
            }
        }
        this.listenerPatterns.put(listener, patterns);
    }

    public synchronized void removeLifecycleListener(LifecycleListener listener) {
        Iterator iterator = this.boundListeners.values().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            set.remove(listener);
        }
        this.listenerPatterns.remove(listener);
    }

    private synchronized Set getTargets(ObjectName source) {
        Set targets = (Set)this.boundListeners.get(source);
        if (targets == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(targets);
    }

    private void fireLoadedEvent(ObjectName objectName) {
        Set targets = this.getTargets(objectName);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.loaded(objectName);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStartingEvent(ObjectName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.starting(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireRunningEvent(ObjectName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.running(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStoppingEvent(ObjectName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.stopping(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStoppedEvent(ObjectName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.stopped(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireFailedEvent(ObjectName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.failed(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireUnloadedEvent(ObjectName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.unloaded(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    public LifecycleBroadcaster createLifecycleBroadcaster(ObjectName objectName) {
        return new RawLifecycleBroadcaster(objectName);
    }

    private class RawLifecycleBroadcaster
    implements LifecycleBroadcaster {
        private final ObjectName objectName;

        public RawLifecycleBroadcaster(ObjectName objectName) {
            this.objectName = objectName;
        }

        public void fireLoadedEvent() {
            BasicLifecycleMonitor.this.addSource(this.objectName);
            BasicLifecycleMonitor.this.fireLoadedEvent(this.objectName);
        }

        public void fireStartingEvent() {
            BasicLifecycleMonitor.this.fireStartingEvent(this.objectName);
        }

        public void fireRunningEvent() {
            BasicLifecycleMonitor.this.fireRunningEvent(this.objectName);
        }

        public void fireStoppingEvent() {
            BasicLifecycleMonitor.this.fireStoppingEvent(this.objectName);
        }

        public void fireStoppedEvent() {
            BasicLifecycleMonitor.this.fireStoppedEvent(this.objectName);
        }

        public void fireFailedEvent() {
            BasicLifecycleMonitor.this.fireFailedEvent(this.objectName);
        }

        public void fireUnloadedEvent() {
            BasicLifecycleMonitor.this.fireUnloadedEvent(this.objectName);
            BasicLifecycleMonitor.this.removeSource(this.objectName);
        }
    }
}

