/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.logging;

import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.logging.ReportDao;
import fr.inria.gforge.spoon.logging.ReportDaoImpl;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class ReportBuilderImpl
implements ReportBuilder {
    private final Map<ReportKey, Object> reportsData = new HashMap<ReportKey, Object>();
    private final ReportDao reportDao;

    ReportBuilderImpl(File resultFile) {
        this.reportDao = new ReportDaoImpl(resultFile);
    }

    @Override
    public ReportBuilder setProjectName(String name) {
        this.reportsData.put(ReportKey.PROJECT_NAME, name);
        return this;
    }

    @Override
    public ReportBuilder setProcessors(String[] processors) {
        this.reportsData.put(ReportKey.PROCESSORS, processors);
        return this;
    }

    @Override
    public ReportBuilder setModuleName(String name) {
        this.reportsData.put(ReportKey.MODULE_NAME, name);
        return this;
    }

    @Override
    public ReportBuilder setInput(String input) {
        this.reportsData.put(ReportKey.INPUT, input);
        return this;
    }

    @Override
    public ReportBuilder setOutput(String output) {
        this.reportsData.put(ReportKey.OUTPUT, output);
        return this;
    }

    @Override
    public ReportBuilder setSourceClasspath(String sourceClasspath) {
        this.reportsData.put(ReportKey.SOURCE_CLASSPATH, sourceClasspath);
        return this;
    }

    @Override
    public ReportBuilder setPerformance(long performance) {
        this.reportsData.put(ReportKey.PERFORMANCE, performance);
        return this;
    }

    @Override
    public void buildReport() {
        this.reportDao.save(this.reportsData);
    }

    static enum ReportKey {
        PROJECT_NAME,
        FRAGMENT_MODE,
        PROCESSORS,
        MODULE_NAME,
        INPUT,
        OUTPUT,
        SOURCE_CLASSPATH,
        PERFORMANCE;

    }
}

