/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.configuration;

import fr.inria.gforge.spoon.Spoon;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.util.LogWrapper;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

abstract class AbstractSpoonConfigurationBuilder
implements SpoonConfigurationBuilder {
    protected final List<String> parameters = new LinkedList<String>();
    protected final Spoon spoon;
    protected final ReportBuilder reportBuilder;

    protected AbstractSpoonConfigurationBuilder(Spoon spoon, ReportBuilder reportBuilder) {
        this.spoon = spoon;
        this.reportBuilder = reportBuilder;
        if (this.spoon.getLog().isInfoEnabled()) {
            this.parameters.add("--level");
            this.parameters.add("INFO");
        }
        if (this.spoon.getLog().isDebugEnabled()) {
            this.parameters.add("--level");
            this.parameters.add("DEBUG");
        }
    }

    @Override
    public SpoonConfigurationBuilder addInputFolder() {
        if (this.spoon.getSrcFolders().length > 0) {
            this.parameters.add("-i");
            String inputs = "";
            for (int i = 0; i < this.spoon.getSrcFolders().length; ++i) {
                File input = this.spoon.getSrcFolders()[i];
                if (!input.exists()) {
                    throw new RuntimeException(input.getName() + " don't exist.");
                }
                inputs = inputs + input.getAbsolutePath();
                if (i == this.spoon.getSrcFolders().length - 1) continue;
                inputs = inputs + File.pathSeparatorChar;
            }
            this.parameters.add(inputs);
            this.reportBuilder.setInput(inputs);
            return this;
        }
        String srcDir = this.spoon.getProject().getBuild().getSourceDirectory();
        File srcDirFile = new File(srcDir);
        if (this.spoon.getSrcFolder() != null && this.spoon.getSrcFolder().exists()) {
            this.parameters.add("-i");
            this.parameters.add(this.spoon.getSrcFolder().getAbsolutePath());
            this.reportBuilder.setInput(this.spoon.getSrcFolder().getAbsolutePath());
            return this;
        }
        if (srcDirFile.exists()) {
            this.parameters.add("-i");
            this.parameters.add(srcDir);
            this.reportBuilder.setInput(srcDir);
            return this;
        }
        throw new RuntimeException(String.format("No source directory for %s project.", this.spoon.getProject().getName()));
    }

    @Override
    public SpoonConfigurationBuilder addOutputFolder() {
        if (!this.spoon.getOutFolder().exists()) {
            this.spoon.getOutFolder().mkdirs();
        }
        this.parameters.add("-o");
        this.parameters.add(this.spoon.getOutFolder().getAbsolutePath());
        if (!this.spoon.isCompileOriginalSources()) {
            this.spoon.getProject().getCompileSourceRoots().clear();
            this.spoon.getProject().addCompileSourceRoot(this.spoon.getOutFolder().getAbsolutePath());
        }
        this.reportBuilder.setOutput(this.spoon.getOutFolder().getAbsolutePath());
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addEnableComments() {
        if (this.spoon.isEnableComments()) {
            this.parameters.add("--enable-comments");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addCompliance() {
        this.parameters.add("--compliance");
        this.parameters.add("" + this.spoon.getCompliance());
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addSourceClasspath() {
        List compileClasspath;
        MavenProject project = this.spoon.getProject();
        try {
            compileClasspath = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException("Cannot get compile classpath elements.", e);
        }
        if (compileClasspath.size() > 1) {
            StringBuilder classpath = new StringBuilder();
            for (int i = 1; i < compileClasspath.size(); ++i) {
                classpath.append((String)compileClasspath.get(i)).append(File.pathSeparatorChar);
            }
            LogWrapper.debug(this.spoon, String.format("Source classpath: %s", classpath.toString()));
            this.parameters.add("--source-classpath");
            this.parameters.add(classpath.toString());
            this.reportBuilder.setSourceClasspath(classpath.toString());
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addNoClasspath() {
        if (this.spoon.isNoClasspath()) {
            this.parameters.add("-x");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addWithImports() {
        if (this.spoon.isWithImports()) {
            this.parameters.add("--with-imports");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addBuildOnlyOutdatedFiles() {
        if (this.spoon.isBuildOnlyOutdatedFiles()) {
            this.parameters.add("--buildOnlyOutdatedFiles");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addNoCopyResources() {
        if (this.spoon.isNoCopyResources()) {
            this.parameters.add("--no-copy-resources");
        }
        return this;
    }

    @Override
    public String[] build() {
        LogWrapper.info(this.spoon, "Running spoon with parameters:");
        LogWrapper.info(this.spoon, this.parameters.toString());
        return this.parameters.toArray(new String[this.parameters.size()]);
    }

    protected String implode(String[] tabToConcatenate, String pathSeparator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tabToConcatenate.length; ++i) {
            builder.append(tabToConcatenate[i]);
            if (i >= tabToConcatenate.length - 1) continue;
            builder.append(pathSeparator);
        }
        return builder.toString();
    }
}

