/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon;

import fr.inria.gforge.spoon.ProcessorProperties;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationFactory;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.logging.ReportFactory;
import fr.inria.gforge.spoon.metrics.PerformanceDecorator;
import fr.inria.gforge.spoon.util.ClasspathHacker;
import fr.inria.gforge.spoon.util.LogWrapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import spoon.Launcher;
import spoon.compiler.Environment;
import spoon.processing.ProcessorPropertiesImpl;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Spoon
extends AbstractMojo {
    @Parameter(property="enableComments", defaultValue="false")
    private boolean enableComments;
    @Parameter(property="folder.src")
    private File srcFolder;
    @Parameter(property="folder.src")
    private File[] srcFolders;
    @Parameter(property="folder.out", defaultValue="${project.build.directory}/generated-sources/spoon")
    private File outFolder;
    @Parameter(property="noClasspath", defaultValue="false")
    private boolean noClasspath;
    @Parameter(property="withImports", defaultValue="false")
    private boolean withImports;
    @Parameter(property="buildOnlyOutdatedFiles", defaultValue="false")
    private boolean buildOnlyOutdatedFiles;
    @Parameter(property="noCopyResources", defaultValue="false")
    private boolean noCopyResources;
    @Parameter(property="processors")
    private String[] processors;
    @Parameter(property="Debug mode", defaultValue="false")
    private boolean debug;
    @Parameter(property="Compile original sources and not source spooned", defaultValue="false")
    private boolean compileOriginalSources;
    @Parameter(property="Java version for spoon", defaultValue="8")
    private int compliance;
    @Parameter
    private ProcessorProperties[] processorProperties;
    @Parameter(property="spoon.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        try {
            ReportBuilder reportBuilder;
            try {
                reportBuilder = ReportFactory.newReportBuilder(this);
            }
            catch (RuntimeException e) {
                LogWrapper.warn(this, e.getMessage(), e);
                return;
            }
            SpoonConfigurationBuilder spoonBuilder = SpoonConfigurationFactory.getConfig(this, reportBuilder);
            reportBuilder.setProjectName(this.project.getName());
            reportBuilder.setModuleName(this.project.getName());
            try {
                spoonBuilder.addInputFolder().addOutputFolder().addCompliance().addNoClasspath().addWithImports().addBuildOnlyOutdatedFiles().addNoCopyResources().addSourceClasspath().addEnableComments().addProcessors().addTemplates();
            }
            catch (RuntimeException e) {
                LogWrapper.warn(this, e.getMessage(), e);
                return;
            }
            this.addArtifactsInClasspathOfTargetClassLoader();
            Launcher spoonLauncher = new Launcher();
            spoonLauncher.setArgs(spoonBuilder.build());
            if (this.processorProperties != null) {
                this.initSpoonProperties(spoonLauncher);
            }
            PerformanceDecorator performance = new PerformanceDecorator(reportBuilder, spoonLauncher);
            performance.execute();
            reportBuilder.buildReport();
        }
        catch (Exception e) {
            LogWrapper.error(this, e.getMessage(), e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void initSpoonProperties(Launcher launcher) throws MojoExecutionException {
        Environment environment = launcher.getEnvironment();
        for (ProcessorProperties processorProperties : this.getProcessorProperties()) {
            ProcessorPropertiesImpl properties = new ProcessorPropertiesImpl();
            Properties xmlProperties = processorProperties.getProperties();
            for (Object key : xmlProperties.keySet()) {
                Cloneable content;
                String sKey = (String)key;
                String value = (String)xmlProperties.get(key);
                String[] tokens = value.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                if (tokens.length == 1) {
                    content = tokens[0].replace("\"", "");
                } else {
                    int i;
                    Cloneable tempContent;
                    String regExSepMap = "^.[^\"]=.*$";
                    String firstContent = tokens[0];
                    boolean isMap = Pattern.matches(regExSepMap, firstContent);
                    if (isMap) {
                        tempContent = new HashMap();
                        for (i = 0; i < tokens.length; ++i) {
                            int equalsIndex = tokens[i].indexOf("=");
                            if (equalsIndex == -1) {
                                throw new MojoExecutionException("Error when parsing the following map property content: " + tokens[i] + ". Please read the documentation.");
                            }
                            String mapKey = tokens[i].substring(0, equalsIndex);
                            String mapValue = tokens[i].substring(equalsIndex + 1);
                            if (StringUtils.isNumeric((String)mapValue)) {
                                try {
                                    int mapIntvalue = Integer.parseInt(mapValue);
                                    tempContent.put(mapKey, mapIntvalue);
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    throw new MojoExecutionException("Error while reading numeric value: " + mapValue);
                                }
                            }
                            mapValue = mapValue.replace("\"", "");
                            tempContent.put(mapKey, mapValue);
                        }
                        content = tempContent;
                    } else {
                        tempContent = new ArrayList();
                        for (i = 0; i < tokens.length; ++i) {
                            if (StringUtils.isNumeric((String)tokens[i])) {
                                try {
                                    int intValue = Integer.parseInt(tokens[i]);
                                    tempContent.add(intValue);
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    throw new MojoExecutionException("Error while reading numeric value: " + tokens[i]);
                                }
                            }
                            String listValue = tokens[i].replace("\"", "");
                            tempContent.add(listValue);
                        }
                        content = tempContent;
                    }
                }
                properties.set(sKey, (Object)content);
            }
            environment.setProcessorProperties(processorProperties.getName(), (spoon.processing.ProcessorProperties)properties);
        }
    }

    private void addArtifactsInClasspathOfTargetClassLoader() throws IOException {
        URL[] urlClassLoader;
        if (this.project.getArtifacts() == null || this.project.getArtifacts().isEmpty()) {
            LogWrapper.info(this, "There is not artifact in this project.");
        } else {
            for (Artifact artifact : this.project.getArtifacts()) {
                LogWrapper.debug(this, artifact.toString());
                ClasspathHacker.addFile(artifact.getFile());
            }
        }
        LogWrapper.info(this, "Running spoon with classpath:");
        for (URL currentURL : urlClassLoader = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()) {
            LogWrapper.info(this, currentURL.toString());
        }
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public File[] getSrcFolders() {
        return this.srcFolders;
    }

    public File getOutFolder() {
        return this.outFolder;
    }

    public boolean isNoClasspath() {
        return this.noClasspath;
    }

    public boolean isWithImports() {
        return this.withImports;
    }

    public boolean isBuildOnlyOutdatedFiles() {
        return this.buildOnlyOutdatedFiles;
    }

    public boolean isNoCopyResources() {
        return this.noCopyResources;
    }

    public String[] getProcessorsPath() {
        return this.processors;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isCompileOriginalSources() {
        return this.compileOriginalSources;
    }

    public int getCompliance() {
        return this.compliance;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setEnableComments(boolean enableComments) {
        this.enableComments = enableComments;
    }

    public boolean isEnableComments() {
        return this.enableComments;
    }

    public ProcessorProperties[] getProcessorProperties() {
        return this.processorProperties;
    }
}

