/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.jodatime;

import com.esotericsoftware.kryo.serialize.LongSerializer;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import java.nio.ByteBuffer;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.BuddhistChronology;
import org.joda.time.chrono.CopticChronology;
import org.joda.time.chrono.EthiopicChronology;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.IslamicChronology;
import org.joda.time.chrono.JulianChronology;

public class JodaDateTimeSerializer
extends SimpleSerializer<DateTime> {
    static final String MILLIS = "millis";
    static final String DATE_TIME = "dt";
    static final String CHRONOLOGY = "ch";
    static final String TIME_ZONE = "tz";

    public DateTime read(ByteBuffer buffer) {
        long millis = LongSerializer.get((ByteBuffer)buffer, (boolean)true);
        Chronology chronology = this.readChronology(buffer);
        DateTimeZone tz = this.readTimeZone(buffer);
        return new DateTime(millis, chronology.withZone(tz));
    }

    private Chronology readChronology(ByteBuffer buffer) {
        String chronologyId = StringSerializer.get((ByteBuffer)buffer);
        return IdentifiableChronology.valueOfId("".equals(chronologyId) ? null : chronologyId);
    }

    private DateTimeZone readTimeZone(ByteBuffer buffer) {
        String tz = StringSerializer.get((ByteBuffer)buffer);
        return "".equals(tz) ? DateTimeZone.getDefault() : DateTimeZone.forID((String)tz.toString());
    }

    public void write(ByteBuffer buffer, DateTime obj) {
        LongSerializer.put((ByteBuffer)buffer, (long)obj.getMillis(), (boolean)true);
        String chronologyId = this.getChronologyId(obj.getChronology());
        StringSerializer.put((ByteBuffer)buffer, (String)(chronologyId == null ? "" : chronologyId));
        if (obj.getZone() != null && obj.getZone() != DateTimeZone.getDefault()) {
            StringSerializer.put((ByteBuffer)buffer, (String)obj.getZone().getID());
        } else {
            StringSerializer.put((ByteBuffer)buffer, (String)"");
        }
    }

    private String getChronologyId(Chronology chronology) {
        return IdentifiableChronology.getIdByChronology(chronology.getClass());
    }

    static enum IdentifiableChronology {
        ISO(null, (Chronology)ISOChronology.getInstance()),
        COPTIC("COPTIC", (Chronology)CopticChronology.getInstance()),
        ETHIOPIC("ETHIOPIC", (Chronology)EthiopicChronology.getInstance()),
        GREGORIAN("GREGORIAN", (Chronology)GregorianChronology.getInstance()),
        JULIAN("JULIAN", (Chronology)JulianChronology.getInstance()),
        ISLAMIC("ISLAMIC", (Chronology)IslamicChronology.getInstance()),
        BUDDHIST("BUDDHIST", (Chronology)BuddhistChronology.getInstance()),
        GJ("GJ", (Chronology)GJChronology.getInstance());

        private final String _id;
        private final Chronology _chronology;

        private IdentifiableChronology(String id, Chronology chronology) {
            this._id = id;
            this._chronology = chronology;
        }

        public String getId() {
            return this._id;
        }

        public static String getIdByChronology(Class<? extends Chronology> clazz) throws IllegalArgumentException {
            for (IdentifiableChronology item : IdentifiableChronology.values()) {
                if (!clazz.equals(item._chronology.getClass())) continue;
                return item._id;
            }
            throw new IllegalArgumentException("Chronology not supported: " + clazz.getSimpleName());
        }

        public static Chronology valueOfId(String id) throws IllegalArgumentException {
            if (id == null) {
                return IdentifiableChronology.ISO._chronology;
            }
            for (IdentifiableChronology item : IdentifiableChronology.values()) {
                if (!id.equals(item._id)) continue;
                return item._chronology;
            }
            throw new IllegalArgumentException("No chronology found for id " + id);
        }
    }
}

