/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serialize.EnumSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;

public class EnumMapSerializer
extends SimpleSerializer<EnumMap<? extends Enum<?>, ?>> {
    private static final Field TYPE_FIELD;
    private final Kryo _kryo;

    public EnumMapSerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    public EnumMap<?, ?> read(ByteBuffer buffer) {
        Class keyType = this._kryo.readClass(buffer).getType();
        EnumMap result = new EnumMap(keyType);
        int size = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
        for (int i = 0; i < size; ++i) {
            Object key = EnumSerializer.get((ByteBuffer)buffer, (Class)keyType);
            Object value = this._kryo.readClassAndObject(buffer);
            result.put(key, value);
        }
        return result;
    }

    public void write(ByteBuffer buffer, EnumMap<? extends Enum<?>, ?> map) {
        this._kryo.writeClass(buffer, this.getKeyType(map));
        IntSerializer.put((ByteBuffer)buffer, (int)map.size(), (boolean)true);
        for (Map.Entry<Enum<?>, ?> entry : map.entrySet()) {
            EnumSerializer.put((ByteBuffer)buffer, entry.getKey());
            this._kryo.writeClassAndObject(buffer, entry.getValue());
        }
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Wrote EnumMap: " + map));
        }
    }

    private Class getKeyType(EnumMap<?, ?> map) {
        try {
            return (Class)TYPE_FIELD.get(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access keys field.", e);
        }
    }

    static {
        try {
            TYPE_FIELD = EnumMap.class.getDeclaredField("keyType");
            TYPE_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("The EnumMap class seems to have changed, could not access expected field.", e);
        }
    }
}

