/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.config.AdminServerProperties;
import de.codecentric.boot.admin.journal.ApplicationEventJournal;
import de.codecentric.boot.admin.journal.store.JournaledEventStore;
import de.codecentric.boot.admin.journal.store.SimpleJournaledEventStore;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.registry.HashingApplicationUrlIdGenerator;
import de.codecentric.boot.admin.registry.StatusUpdateApplicationListener;
import de.codecentric.boot.admin.registry.StatusUpdater;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import de.codecentric.boot.admin.registry.store.SimpleApplicationStore;
import de.codecentric.boot.admin.web.client.ApplicationOperations;
import de.codecentric.boot.admin.web.client.BasicAuthHttpHeaderProvider;
import de.codecentric.boot.admin.web.client.HttpHeadersProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;

@Configuration
@EnableConfigurationProperties(value={AdminServerProperties.class})
public class AdminServerCoreConfiguration {
    private final AdminServerProperties adminServerProperties;

    public AdminServerCoreConfiguration(AdminServerProperties adminServerProperties) {
        this.adminServerProperties = adminServerProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationRegistry applicationRegistry(ApplicationStore applicationStore, ApplicationIdGenerator applicationIdGenerator) {
        return new ApplicationRegistry(applicationStore, applicationIdGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationIdGenerator applicationIdGenerator() {
        return new HashingApplicationUrlIdGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpHeadersProvider httpHeadersProvider() {
        return new BasicAuthHttpHeaderProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationOperations applicationOperations(RestTemplateBuilder restTemplBuilder, HttpHeadersProvider headersProvider) {
        RestTemplateBuilder builder = restTemplBuilder.messageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()}).errorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return false;
            }
        });
        return new ApplicationOperations(builder.build(), headersProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public StatusUpdater statusUpdater(ApplicationStore applicationStore, ApplicationOperations applicationOperations) {
        StatusUpdater statusUpdater = new StatusUpdater(applicationStore, applicationOperations);
        statusUpdater.setStatusLifetime(this.adminServerProperties.getMonitor().getStatusLifetime());
        return statusUpdater;
    }

    @Bean
    @Qualifier(value="updateTaskScheduler")
    public ThreadPoolTaskScheduler updateTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("updateTask");
        return taskScheduler;
    }

    @Bean
    @ConditionalOnMissingBean
    public StatusUpdateApplicationListener statusUpdateApplicationListener(StatusUpdater statusUpdater, @Qualifier(value="updateTaskScheduler") ThreadPoolTaskScheduler taskScheduler) {
        StatusUpdateApplicationListener listener = new StatusUpdateApplicationListener(statusUpdater, taskScheduler);
        listener.setUpdatePeriod(this.adminServerProperties.getMonitor().getPeriod());
        return listener;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationEventJournal applicationEventJournal(JournaledEventStore journaledEventStore) {
        return new ApplicationEventJournal(journaledEventStore);
    }

    @Bean
    @ConditionalOnMissingBean
    public JournaledEventStore journaledEventStore() {
        return new SimpleJournaledEventStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationStore applicationStore() {
        return new SimpleApplicationStore();
    }
}

