/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.statements.builder;

import de.bechte.junit.runners.context.statements.builder.ClassStatementBuilder;
import de.bechte.junit.runners.context.statements.builder.DefaultStatementBuilderFactory;
import de.bechte.junit.runners.context.statements.builder.MethodStatementBuilder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatementBuilderFactory {
    protected static final String PROPERTY_KEY = StatementBuilderFactory.class.getCanonicalName();
    private static StatementBuilderFactory factory = null;

    public static StatementBuilderFactory getDefault() {
        if (factory == null) {
            StatementBuilderFactory.lazyLoadFactory();
        }
        return factory;
    }

    private static void lazyLoadFactory() {
        String factoryName = System.getProperty(PROPERTY_KEY);
        try {
            factory = factoryName == null ? new DefaultStatementBuilderFactory() : (StatementBuilderFactory)Class.forName(factoryName).newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("JUnit system not configured correctly. Cannot find StatementBuilderFactory! Invalid factory name given: " + factoryName, t);
        }
    }

    protected StatementBuilderFactory() {
    }

    public abstract List<ClassStatementBuilder> getBuildersForClasses();

    public abstract List<MethodStatementBuilder> getBuildersForMethods();
}

