/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.statements;

import de.bechte.junit.runners.context.statements.DefaultStatementExecutorFactory;
import de.bechte.junit.runners.context.statements.StatementExecutor;

public abstract class StatementExecutorFactory {
    protected static final String PROPERTY_KEY = StatementExecutorFactory.class.getCanonicalName();
    private static StatementExecutorFactory factory = null;

    public static StatementExecutorFactory getDefault() {
        if (factory == null) {
            StatementExecutorFactory.lazyLoadFactory();
        }
        return factory;
    }

    private static void lazyLoadFactory() {
        String factoryName = System.getProperty(PROPERTY_KEY);
        try {
            factory = factoryName == null ? new DefaultStatementExecutorFactory() : (StatementExecutorFactory)Class.forName(factoryName).newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("JUnit system not configured correctly. Cannot find StatementExecutorFactory! Invalid factory name given: " + factoryName, t);
        }
    }

    protected StatementExecutorFactory() {
    }

    public abstract StatementExecutor getExecutorForClasses();

    public abstract StatementExecutor getExecutorForMethods();
}

