package com.xunyi.user.config;

import com.google.common.collect.Lists;
import com.xunyi.passport.core.IdentityType;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class EntranceConfig {

    private Map<String, Config> entrances;

    public EntranceConfig(Map<String, Config> entrances) {
        this.entrances = entrances;
    }

    public boolean support(String key) {
        return this.entrances.containsKey(key);
    }

    private Config getEntranceConfig(String entrance) {
        return entrances.get(entrance);
    }

    public AuthenticationKey lookup(String entrance, IdentityType type) {
        EntranceConfig.Config config = getEntranceConfig(entrance);
        if (config == null) {
            throw new IllegalStateException("entrance: " + entrance + " config invalid");
        }
        for (AuthenticationKey authentication : config.getAuthentications()) {
            if (authentication.getIdentityType() == type) {
                return authentication;
            }
        }
        throw new IllegalStateException("Unsupported '" + entrance + "' type: '" + type + "'");
    }

    public boolean isEnable(String entrance, EntranceFeature feature) {
        var config = getEntranceConfig(entrance);
        if (config == null) {
           return feature.enabledByDefault();
        }
        var features = config.getFeatures();
        Boolean value = features.get(feature.name());
        if (value == null) {
            return feature.enabledByDefault();
        }
        return value;
    }



    @Getter @Setter
    public static class Config {

        private Map<String, String> metadata = new HashMap<>();

        private Map<String, Boolean> features = new HashMap<>();

        private List<AuthenticationKey> authentications = Lists.newArrayList();

        public boolean enable = true;
    }
}
