package com.xunyi.user.config;

import com.xunyi.passport.core.IdentityType;
import lombok.EqualsAndHashCode;

/**
 * group 如登陆&安全      登陆手机，安全手机
 */
@EqualsAndHashCode
public class AuthenticationKey {


    private IdentityType identityType;
    private String group;


    private static final String DIVIDER_TOKEN = "-";


    AuthenticationKey(IdentityType identityType, String group) {
        this.group = group;
        this.identityType = identityType;
    }

    public static AuthenticationKey valueOf(String symbol) {
        if (symbol == null || symbol.length() == 0) {
            throw new IllegalArgumentException("symbol string cannot be empty");
        }
        int splitIndex = symbol.indexOf(DIVIDER_TOKEN);
        String identityTypeString = splitIndex != -1 ? symbol.substring(0, splitIndex) : symbol;
        IdentityType type = IdentityType.valueOf(identityTypeString);

        String groupString = splitIndex != -1 ? symbol.substring(splitIndex + 1) : null;
        if (groupString != null) {
            if (groupString.length() == 0) {
                groupString = null;
            }
        }

        return new AuthenticationKey(type, groupString);
    }

    public static AuthenticationKey valueOf(IdentityType type, String group) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        return new AuthenticationKey(type, group);
    }

    public String getGroup() {
        return group;
    }

    public IdentityType getIdentityType() {
        return identityType;
    }

    @Override
    public String toString() {
        return identityType + "-"+ group;
    }
}
