package com.xunyi.user.config;

import lombok.Getter;
import lombok.Setter;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 认证配置
 */
@Getter @Setter
public class AuthenticationConfig {

    /**
     * 是否要求必须绑定手机号 （允许解绑或覆盖）
     * 当第三方登录时将，会进入绑定手机页面 ， 且允许手机号创建用户
     */

    private Map<AuthenticationKey, Config> authentications = new HashMap<>();

    public AuthenticationConfig(Map<AuthenticationKey, Config> authentications) {
        this.authentications = authentications;
    }

    //    @Data
//    public static class IdentityGroupAuthenticationConfig {
//
//
//    }
//
//    public boolean support(IdentityGroup identityGroup) {
//        return this.identityGroup.containsKey(identityGroup);
//    }
//
//    public String getValueOf(IdentityGroup identityGroup, String key) {
//        IdentityGroupAuthenticationConfig config = this.identityGroup.get(identityGroup);
//        Map<String, String> metadata = config.getMetadata();
//        return metadata.get(key);
//    }
//
//    public boolean isRequiredBindMobile() {
//        return requiredBindMobile;
//    }
//
//    public boolean isEnable(IdentityGroup identityGroup, AuthenticationFeature feature) {
//
//        IdentityGroupAuthenticationConfig config = this.identityGroup.get(identityGroup);
//        Map<String, Boolean> features = config.getFeatures();
//        String key = feature.name();
//        Object value = features.get(key);
//        if (value == null) {
//            return feature.enabledByDefault();
//        }
//        return (boolean) value;
//    }

    public Set<AuthenticationKey> keys() {
        return this.authentications.keySet();
    }
    public Config getAuthenticationConfig(AuthenticationKey key) {

        Config config = this.authentications.get(key);
        return config;
    }
    public boolean isEnable(AuthenticationKey key, AuthenticationFeature feature) {
        var config = getAuthenticationConfig(key);
        if (config == null) {
            return feature.enabledByDefault();
        }

        String featureKey = feature.name();
        var features = config.getFeatures();
        Boolean value = features.get(featureKey);
        if (value == null) {
            return feature.enabledByDefault();
        }
        return value;
    }

    @Getter @Setter
    public static class Config {

        private Map<String, String> metadata = new HashMap<>();

        private Map<String, Boolean> features = new HashMap<>();

        private boolean enable = true;
    }

}
