package com.xunyi.user.config;

import com.xunyi.passport.core.*;
import com.xunyi.passport.core.http.CookieControl;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * 应用
 */
@Slf4j
@Setter
public class App {


    @Getter
    private String id;

    /**
     * 名称
     */
    @Getter
    private String name;


    /**
     * LOGO 42x48
     */
    @Getter
    private String logo;

    /**
     * redirectUrl 使用
     */
    //private String baseUrl;
    /**
     * baseUrl: http://webpassport.office.pingtech.net/
     * baseUrl: http://h5.pingtech.net/login/
     * baseUrl: http://webpassport.pingtech.net/
     */
    @Getter
    private Map<String, String> metadata;

    @Getter
    private Map<String, Boolean> features = new HashMap<>();

    @Getter
    private CookieControl cookieControl;


    private EntranceConfig entrances;


    private AuthenticationConfig authentications;

    public App(AppProperties properties) {
        this.id = properties.getId();
        this.name = properties.getName();
        this.logo = properties.getLogo();
        this.metadata = properties.getMetadata();
        this.features = properties.getFeatures();
        this.cookieControl = properties.getCookieControl();
        this.entrances = new EntranceConfig(properties.getEntrances());
        this.authentications = new AuthenticationConfig(properties.getAuthentications());
    }

    public boolean enableByEntrance(String entrance, EntranceFeature feature) {
        return entrances.isEnable(entrance, feature);
    }

    public boolean enableByAuthenticate(AuthenticationKey key, AuthenticationFeature feature) {
        return this.authentications.isEnable(key, feature);
    }

    public boolean enableByAuthenticate(String entrance, IdentityType type, AuthenticationFeature feature) {
        AuthenticationKey key = entrances.lookup(entrance, type);
        return enableByAuthenticate(key, feature);
    }

    public String lookupSNSApp(String entrance, SNSType type) {
        IdentityType identityType = type.toIdentityType();
        AuthenticationKey key = entrances.lookup(entrance, identityType);
        AuthenticationConfig.Config config = this.authentications.getAuthenticationConfig(key);
        if (config == null) {
            throw new IllegalStateException("authentication key: " + key + " config unsupported, supports [{" +this.authentications.keys()+ "}]");
        }
        Map<String, String> metadata = config.getMetadata();
        return metadata.get("app");
    }
}
