/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.user.config;

import com.xunyi.passport.core.IdentityType;

public class AuthenticationKey {
    private IdentityType identityType;
    private String group;
    private static final String DIVIDER_TOKEN = "-";

    AuthenticationKey(IdentityType identityType, String group) {
        this.group = group;
        this.identityType = identityType;
    }

    public static AuthenticationKey valueOf(String symbol) {
        if (symbol == null || symbol.length() == 0) {
            throw new IllegalArgumentException("symbol string cannot be empty");
        }
        int splitIndex = symbol.indexOf(DIVIDER_TOKEN);
        String identityTypeString = splitIndex != -1 ? symbol.substring(0, splitIndex) : symbol;
        String group = splitIndex != -1 ? symbol.substring(splitIndex + 1) : null;
        IdentityType type = IdentityType.valueOf((String)identityTypeString);
        return new AuthenticationKey(type, group);
    }

    public static AuthenticationKey valueOf(IdentityType type, String group) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        return new AuthenticationKey(type, group);
    }

    public String getGroup() {
        return this.group;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public String toString() {
        return "AuthenticationKey(identityType=" + this.getIdentityType() + ", group=" + this.getGroup() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationKey)) {
            return false;
        }
        AuthenticationKey other = (AuthenticationKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdentityType this$identityType = this.getIdentityType();
        IdentityType other$identityType = other.getIdentityType();
        if (this$identityType == null ? other$identityType != null : !this$identityType.equals(other$identityType)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdentityType $identityType = this.getIdentityType();
        result = result * 59 + ($identityType == null ? 43 : $identityType.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }
}

