/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.user.config;

import com.google.common.collect.Lists;
import com.xunyi.passport.core.IdentityType;
import com.xunyi.user.config.AuthenticationKey;
import com.xunyi.user.config.EntranceFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntranceConfig {
    private Map<String, Config> entrances;

    public EntranceConfig(Map<String, Config> entrances) {
        this.entrances = entrances;
    }

    public boolean support(String key) {
        return this.entrances.containsKey(key);
    }

    private Config getEntranceConfig(String entrance) {
        return this.entrances.get(entrance);
    }

    public AuthenticationKey lookup(String entrance, IdentityType type) {
        Config config = this.getEntranceConfig(entrance);
        if (config == null) {
            throw new IllegalStateException("entrance: " + entrance + " config invalid");
        }
        for (AuthenticationKey authentication : config.getAuthentications()) {
            if (authentication.getIdentityType() != type) continue;
            return authentication;
        }
        throw new IllegalStateException("Unsupported " + entrance + " type: " + type);
    }

    public boolean isEnable(String entrance, EntranceFeature feature) {
        Config config = this.getEntranceConfig(entrance);
        if (config == null) {
            return feature.enabledByDefault();
        }
        Map<String, Boolean> features = config.getFeatures();
        Boolean value = features.get(feature.name());
        if (value == null) {
            return feature.enabledByDefault();
        }
        return value;
    }

    public static class Config {
        private Map<String, String> metadata = new HashMap<String, String>();
        private Map<String, Boolean> features = new HashMap<String, Boolean>();
        private List<AuthenticationKey> authentications = Lists.newArrayList();
        public boolean enable = true;

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public Map<String, Boolean> getFeatures() {
            return this.features;
        }

        public List<AuthenticationKey> getAuthentications() {
            return this.authentications;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        public void setFeatures(Map<String, Boolean> features) {
            this.features = features;
        }

        public void setAuthentications(List<AuthenticationKey> authentications) {
            this.authentications = authentications;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }
}

