/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.user.config;

import com.xunyi.passport.core.IdentityType;

public class AuthenticationKey {
    private IdentityType identityType;
    private String group;
    private static final String DIVIDER_TOKEN = "-";

    AuthenticationKey(IdentityType identityType, String group) {
        this.group = group;
        this.identityType = identityType;
    }

    public static AuthenticationKey valueOf(String symbol) {
        if (symbol == null || symbol.length() == 0) {
            throw new IllegalArgumentException("symbol string cannot be empty");
        }
        int splitIndex = symbol.indexOf(DIVIDER_TOKEN);
        String identityTypeString = splitIndex != -1 ? symbol.substring(0, splitIndex) : symbol;
        String group = splitIndex != -1 ? symbol.substring(splitIndex + 1) : null;
        IdentityType type = IdentityType.valueOf((String)identityTypeString);
        return new AuthenticationKey(type, group);
    }

    public static AuthenticationKey valueOf(IdentityType type, String group) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        return new AuthenticationKey(type, group);
    }

    public String getGroup() {
        return this.group;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }
}

