/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.user.config;

import com.xunyi.passport.core.IdentityType;
import com.xunyi.passport.core.http.CookieControl;
import com.xunyi.user.config.AppProperties;
import com.xunyi.user.config.AuthenticationConfig;
import com.xunyi.user.config.AuthenticationFeature;
import com.xunyi.user.config.AuthenticationKey;
import com.xunyi.user.config.EntranceConfig;
import com.xunyi.user.config.EntranceFeature;
import java.util.HashMap;
import java.util.Map;

public class App {
    private String id;
    private String name;
    private String logo;
    private Map<String, String> metadata;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private CookieControl cookieControl;
    private EntranceConfig entrances;
    private AuthenticationConfig authentications;

    public App(AppProperties properties) {
        this.id = properties.getId();
        this.name = properties.getName();
        this.logo = properties.getLogo();
        this.metadata = properties.getMetadata();
        this.features = properties.getFeatures();
        this.cookieControl = properties.getCookieControl();
        this.entrances = new EntranceConfig(properties.getEntrances());
        this.authentications = new AuthenticationConfig(properties.getAuthentications());
    }

    public boolean enableByEntrance(String entrance, EntranceFeature feature) {
        return this.entrances.isEnable(entrance, feature);
    }

    public boolean enableByAuthenticate(AuthenticationKey key, AuthenticationFeature feature) {
        return this.authentications.isEnable(key, feature);
    }

    public boolean enableByAuthenticate(String entrance, IdentityType type, AuthenticationFeature feature) {
        AuthenticationKey key = this.entrances.lookup(entrance, type);
        return this.enableByAuthenticate(key, feature);
    }

    public String lookupSNSApp(String entrance, IdentityType type) {
        AuthenticationKey key = this.entrances.lookup(entrance, type);
        AuthenticationConfig.Config config = this.authentications.getAuthenticationConfig(key);
        Map<String, String> metadata = config.getMetadata();
        return metadata.get("app");
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFeatures(Map<String, Boolean> features) {
        this.features = features;
    }

    public void setCookieControl(CookieControl cookieControl) {
        this.cookieControl = cookieControl;
    }

    public void setEntrances(EntranceConfig entrances) {
        this.entrances = entrances;
    }

    public void setAuthentications(AuthenticationConfig authentications) {
        this.authentications = authentications;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLogo() {
        return this.logo;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public CookieControl getCookieControl() {
        return this.cookieControl;
    }
}

