package com.xunyi.passport.client;

import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.passport.client.dto.SNSAuthorizeUriCreateInput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient("user-webpassport")
public interface UserWebClient {

    @PostMapping("/apps/{app}/sns/authorize-uri")
    ReturnResult<String> authorizeUri(
            @PathVariable("app") String app,
            @RequestBody SNSAuthorizeUriCreateInput input
    );


}
