package com.xunyi.passport.client;

import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.passport.client.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("user-center")
public interface UserCenterClient {


    @PostMapping("/apps/{app}/pwd-login")
    ReturnResult<LoginOutput> pwdLogin(
            @PathVariable(name = "app") String app,
            @RequestBody PwdLoginInput input
    );

    @PostMapping("/apps/{app}/mobile-login")
    ReturnResult<LoginOutput> mobileLogin(
            @PathVariable(name = "app") String app,
            @RequestBody MobileLoginInput input
    );

    @PostMapping("/apps/{app}/sns-login")
    ReturnResult<LoginOutput> snsLogin(
            @PathVariable(name = "app") String app,
            @RequestBody SNSLoginInput input
    );

    @PostMapping("/apps/{app}/mobile-signUp")
    ReturnResult<?> mobileSignUp(
            @PathVariable(name = "app") String app,
            @RequestBody MobileSignUpInput input
    );

    @PostMapping("/apps/{app}/email-signUp")
    ReturnResult<?> emailSignUp(
            @PathVariable(name = "app") String app,
            @RequestBody EmailSignUpInput input
    );

    @PostMapping("/apps/{app}/username-signUp")
    ReturnResult<?> usernameSignUp(
            @PathVariable(name = "app") String app,
            @RequestBody UsernameSignUpInput input
    );


    @PostMapping("/sendMobileCode")
    ReturnResult sendMobileCode(
            @RequestBody SendMobileCodeInput input
    );

    @PostMapping("/verifyMobileCode")
    ReturnResult<VerifyMobileCodeOutput> verifyMobileCode(
            @RequestBody VerifyMobileCodeInput input
    );

    @GetMapping("/apps/{app}/getUserIdByIdentity")
    ReturnResult<GetUserIdByIdentityOutput> getUserIdByIdentity(
            @PathVariable(name = "app") String app,
            @RequestParam("identityType") IdentityType identityType,
            @RequestParam("identifier") String identifier
    );

    @PostMapping("/apps/{app}/verifyUserPwd")
    ReturnResult verifyUserPwd(
            @PathVariable(name = "app") String app,
            @RequestBody VerifyUserPwdInput input
    );

    @GetMapping("/apps/{app}/getIdentityByUid")
    ReturnResult<UserIdentityOutput> getIdentityByUid(
            @PathVariable(name = "app") String app,
            @RequestParam("uid") long uid,
            @RequestParam("identityType") IdentityType identityType
    );

    @GetMapping("/getIdentitiesByUid")
    ReturnResult<List<UserIdentityOutput>> getIdentitiesByUid(
            @RequestParam("uid") long uid,
            @RequestParam("identityTypes") List<IdentityType> identityTypes
    );





    @PostMapping("/apps/{app}/iv/identity-verify")
    ReturnResult<IVVerifyOutput> createIdentityVerify(
            @PathVariable(name = "app") String app,
            @RequestBody IdentityVerifyCreateInput input
    );


    @PostMapping("/apps/{app}/account/password")
    ReturnResult<?> setPassword(
            @PathVariable(name = "app") String app,
            @RequestBody SetPasswordInput input
    );

    @PostMapping("/apps/{app}/account/mobile")
    ReturnResult<?> setMobile(
            @PathVariable(name = "app") String app,
            @RequestBody SetMobileInput input
    );

    @PostMapping("/apps/{app}/account/email")
    ReturnResult<?> setEmail(
            @PathVariable(name = "app") String app,
            @RequestBody SetEmailInput input
    );

    @PostMapping("/apps/{app}/account/sns-bind")
    ReturnResult<?> snsBind(
            @PathVariable(name = "app") String app,
            @RequestBody SNSBindInput input
    );

    @PostMapping("/apps/{app}/account/sns-unbind")
    ReturnResult<?> snsUnbind(
            @PathVariable(name = "app") String app,
            @RequestBody SNSUnbindInput input
    );

}
