package com.xunyi.passport.client;

import com.xunyi.micro.message.ReturnResult;
import com.xunyi.passport.client.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient("user-center")
public interface UserCenterClient {


    @PostMapping("/pwdLogin")
    ReturnResult<LoginOutput> pwdLogin(
            @RequestBody PwdLoginInput input
    );

    @PostMapping("/mobileLogin")
    ReturnResult<LoginOutput> mobileLogin(
            @RequestBody MobileLoginInput input
    );

    @PostMapping("/snsLogin")
    ReturnResult<LoginOutput> snsLogin(
            @RequestBody SNSLoginInput input
    );

    @PostMapping("/mobileSignUp")
    ReturnResult mobileSignUp(
            @RequestBody MobileSignUpInput input
    );

    @PostMapping("/emailSignUp")
    ReturnResult emailSignUp(
            @RequestBody EmailSignUpInput input
    );

    @PostMapping("/usernameSignUp")
    ReturnResult usernameSignUp(
            @RequestBody UsernameSignUpInput input
    );


    @PostMapping("/sendMobileCode")
    ReturnResult sendMobileCode(
            @RequestBody SendMobileCodeInput input
    );

    @PostMapping("/verifyMobileCode")
    ReturnResult<VerifyMobileCodeOutput> verifyMobileCode(
            @RequestBody VerifyMobileCodeInput input
    );

    @GetMapping("/getUserIdByIdentity")
    ReturnResult<GetUserIdByIdentityOutput> getUserIdByIdentity(
            @RequestParam("identityType") IdentityType identityType,
            @RequestParam("identifier") String identifier
    );

    @GetMapping("/getIdentityByUid")
    ReturnResult<UserIdentityOutput> getIdentityByUid(
            @RequestParam("uid") long uid,
            @RequestParam("identityType") IdentityType identityType
    );

    @GetMapping("/getIdentitiesByUid")
    ReturnResult<List<UserIdentityOutput>> getIdentitiesByUid(
            @RequestParam("uid") long uid,
            @RequestParam("identityTypes") List<IdentityType> identityTypes
    );

    @PostMapping("/snsBind")
    ReturnResult<SNSBindInput> snsBind(
            @RequestBody SNSBindInput input
    );

    @PostMapping("/snsUnbind")
    ReturnResult<SNSUnbindInput> snsUnbind(
            @RequestBody SNSUnbindInput input
    );


    @PostMapping("/iv/verifyMobile")
    ReturnResult<IVVerifyOutput> verifyMobile(
            @RequestBody IVVerifyMobileInput input
    );

    @PostMapping("/iv/verifyEmail")
    ReturnResult<IVVerifyOutput> verifyEmail(
            @RequestBody IVVerifyEmailInput input
    );

    @PostMapping("/iv/verifyPassword")
    ReturnResult<IVVerifyOutput> verifyPassword(
            @RequestBody IVVerifyPasswordInput input
    );

    @PostMapping("/iv/verifySNS")
    ReturnResult<IVVerifyOutput> verifySNS(
            @RequestBody IVVerifySNSInput input
    );

    @PostMapping("/account/passwordFind")
    ReturnResult passwordFind(
            @RequestBody PasswordFindInput input
    );

    @PostMapping("/account/passwordModify")
    ReturnResult passwordModify(
            @RequestBody PasswordModifyInput input
    );

}
