package com.xunyi.micro.validate.constraintvalidators;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.trie4j.patricia.TailPatriciaTrie;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Slf4j
public class TabooUtils {

    private static TailPatriciaTrie PAT;
    static {
        PAT = new TailPatriciaTrie();
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource("classpath:taboo/words.txt");
        try (InputStream is = resource.getInputStream()) {
            List<String> keywords = IOUtils.readLines(is, StandardCharsets.UTF_8);
            log.info("load keywords size:{}", keywords.size());
            for (String keyword : keywords) {
                PAT.insert(keyword);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    public static String findWord(CharSequence chars) {
        StringBuilder builder = new StringBuilder();
        int index = PAT.findShortestWord(chars, 0, chars.length(), builder);
        if (index >= 0) {
            log.warn("find chars:{} taboo index:{} taboo word: {}", chars, index, builder);
        }
        return builder.toString();
    }
}
