package com.xunyi.micro.propagation;



import com.xunyi.micro.propagation.context.Context;

import java.util.List;

/**
 * 传播
 */
public interface Propagation {

    List<String> keys();


    /**
     * 给Carrier
     * @param <C> 载体
     */
    interface Setter<C> {
        void put(C carrier, String key, String value);
    }

    /**
     * @param <C> carrier 载体
     * @return 注入器
     */
    <C> Context.Injector<C> injector(Setter<C> setter);



    /**
     *
     * @param <C> 载体
     */
    interface Getter<C>{
        String get(C carrier, String key);
    }

    /**
     * @param <C> 载体
     * @return 提取器
     */
    <C> Context.Extractor<C> extractor(Getter<C> getter);
}
