package com.xunyi.micro.id;


import java.util.Base64;

/**
 * base64
 *
 */
public class SnowflakeGenerator implements IDGenerator{

    private final static long ORIGIN_TIME = 1480166465631L;

    private final static long TIMESTAMP_BIT = 41;
    private final static long DATA_CENTER_BIT = 5;
    private final static long WORKER_BIT = 5;
    private final static long SEQUENCE_BIT = 10;

    private final static long TIMESTAMP_MASK = ~(-1L << TIMESTAMP_BIT);
    private final static long DATA_CENTER_MASK = ~(-1L << DATA_CENTER_BIT);
    private final static long WORKER_MASK = ~(-1L << WORKER_BIT);
    private final static long SEQUENCE_MASK = ~(-1L << SEQUENCE_BIT);

    private final static long TIMESTAMP_SHIFT = DATA_CENTER_BIT + SEQUENCE_BIT + WORKER_BIT;
    private final static long DATA_CENTER_SHIFT = SEQUENCE_BIT + WORKER_BIT;
    private final static long WORKER_SHIFT = SEQUENCE_BIT;


    private long lastTime = -1L;
    private long dataCenterId;
    private long workerId;
    private long sequence = 0L;

    protected long nextTime() {
        long timestamp = time();
        while (timestamp <= lastTime) {
            timestamp = time();
        }
        return timestamp;
    }

    protected long time() {
        return System.currentTimeMillis();
    }

    @Override
    public String name() {
        return "Snowflake";
    }

    public SnowflakeGenerator(long dataCenterId, long workerId) {
        if (dataCenterId > DATA_CENTER_MASK || dataCenterId < 0) {
            throw new IllegalArgumentException("dataCenterId can't be geater then DATA_CENTER_MASK");
        }
        if (workerId > WORKER_MASK || workerId < 0) {
            throw new IllegalArgumentException("workerId can't be geater then WORKER_MASK");
        }
        this.dataCenterId = dataCenterId;
        this.workerId = workerId;
    }

    private Base64.Encoder encoder = Base64.getUrlEncoder();

    private static final char[] toBase62 = {
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
            'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
            'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
            'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
            '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
    };
    @Override
    public synchronized String nextId() {
        long now = this.time();

        if (now < lastTime) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (now == lastTime) {
            sequence = (sequence + 1) & SEQUENCE_MASK;
            if (sequence == 0L) {
                now = nextTime();
            }
        } else {
            sequence = 0L;
        }
        lastTime = now;

        long time = now - ORIGIN_TIME;
        long id = (time) << TIMESTAMP_SHIFT   //时间
                | this.dataCenterId << DATA_CENTER_SHIFT  //
                | this.workerId << WORKER_SHIFT  //
                | this.sequence;


        char[] chars = new char[12];
        int i= 12;
        long value = id;
        while (i-- > 0) {
            chars[i] = toBase62[(int)(value % 62)];
            value = value/62;
        }

//        byte[] data = new byte[8];
//        data[0] = (byte)(id >> 56 & 0xff); //避免头尾6位为
//        data[1] = (byte)(id >> 48 & 0xff);
//        data[2] = (byte)(id >> 40 & 0xff);
//
//        data[3] = (byte)(id >> 32 & 0xff);
//        data[4] = (byte)(id >> 24 & 0xff);
//        data[5] = (byte)(id >> 16 & 0xff);
//
//        data[6] = (byte)(id >> 8 & 0xff);
//        data[7] = (byte)(id & 0xff);
//
//        byte[] encodeId = encoder.encode(data);
//        //将最后以为字符利用起来
//        byte[]

        return new String(chars);
    }

}
