package com.xunyi.micro.grpc;


import com.google.common.collect.Lists;
import com.xunyi.micro.grpc.discovery.DiscoveryChannelFactory;
import com.xunyi.micro.grpc.sleuth.TraceClientInterceptor;
import io.grpc.ClientInterceptor;
import io.grpc.LoadBalancer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.DiscoveryClient;
//import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Collections;
import java.util.List;

@Configuration
@EnableConfigurationProperties(value = GRPCChannelsProperties.class)
@ConditionalOnClass({GRPCChannelFactory.class, LoadBalancer.class})
@AutoConfigureAfter({SimpleDiscoveryClientAutoConfiguration.class, ConsulDiscoveryClientConfiguration.class})
@ConditionalOnBean({DiscoveryClient.class})
public class GRPCDiscoveryAutoConfiguration {


//    @ConditionalOnMissingBean
//    @Bean
//    public LoadBalancer.Factory grpcLoadBalancerFactory() {
//        return RoundRobinLoadBalancerFactory.getInstance();
//    }

    @Bean
    @ConditionalOnClass(GRPCClient.class)
    public GRPCClientBeanPostProcessor clientBeanPostProcessor() {
        return new GRPCClientBeanPostProcessor();
    }


    @Bean
    public GRPCChannelFactory discoveryClientChannelFactory(GRPCChannelsProperties properties,
                                                            DiscoveryClient discoveryClient,
//                                                            LoadBalancer.Factory loadBalancerFactory,
                                                            @Autowired(required = false) TraceClientInterceptor interceptor
//                                                            @Autowired(required = false) List<ClientInterceptor> interceptors
                                                            ) {
        List<ClientInterceptor> interceptors = Lists.newArrayList();
        if (interceptor != null) {
            interceptors.add(interceptor);
        }
        return new DiscoveryChannelFactory(properties, discoveryClient, interceptors);
    }

//    @Configuration
//    protected static class DiscoveryGRPCClientAutoConfiguration {
//        protected DiscoveryGRPCClientAutoConfiguration() {
//        }
//
//        @ConditionalOnMissingBean
//
//    }

//    @Configuration
//    @ConditionalOnBean({org.springframework.cloud.sleuth.Tracer.class}) //这个不生效
//    protected static class TracerAutoConfiguration {
//
//
//        @ConditionalOnMissingBean
//        @Bean
//        public TraceClientInterceptor interceptor(Tracer tracer) {
//            return new TraceClientInterceptor(tracer, new MetadataInjector());
//        }
//
//    }
}
