package com.xunyi.micro.data.web;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;

public class MissingXYTokenException extends ServletRequestBindingException {

    private final MethodParameter parameter;

    public MissingXYTokenException(MethodParameter parameter) {
        super("");
        this.parameter = parameter;
    }

    @Override
    public String getMessage() {
        return "Missing XYToken or method parameter of type " + this.parameter.getNestedParameterType().getSimpleName();
    }

    public MethodParameter getParameter() {
        return parameter;
    }
}
