package com.xunyi.micro.data.transformer;

import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class BeanCopyFunction<I, O> implements Function<I, O> {

    protected final Class<O> entityClass;

    public BeanCopyFunction() {
        this(null);
    }


    public BeanCopyFunction(Class<O> clazz) {
        if (clazz == null) {
            Class<?> copyFunction = this.getClass();
            List<TypeInformation<?>> arguments = ClassTypeInformation.from(copyFunction)
                    .getRequiredSuperTypeInformation(BeanCopyFunction.class)
                    .getTypeArguments();
            clazz = (Class<O>) resolveTypeParameter(arguments, 1,
                    () -> String.format("Could not resolve Output type of %s!", copyFunction));
        }
        this.entityClass = clazz;
    }

    private static Class<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index,
                                                 Supplier<String> exceptionMessage) {

        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }

        return arguments.get(index).getType();
    }


    private @NonNull O newOutputInstance()  {
        return BeanUtils.instantiateClass(this.entityClass);
    }

    @Override
    public O apply(I input) {
        O output = this.newOutputInstance();
        Assert.notNull(output, "BeanCopyFunction O Annotation require not null");
        BeanUtils.copyProperties(input, output);
        return output;

    }
}
