/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.propagation.instrument.web.client.feign;

import com.xunyi.micro.propagation.instrument.web.client.feign.LazyPropagationFeignClient;
import com.xunyi.micro.propagation.instrument.web.client.feign.PropagationFeignClient;
import com.xunyi.micro.propagation.instrument.web.client.feign.PropagationLoadBalancerFeignClient;
import feign.Client;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.util.ClassUtils;

public class PropagationFeignObjectWrapper {
    private static final boolean ribbonPresent = ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient", null) && ClassUtils.isPresent((String)"org.springframework.cloud.netflix.ribbon.SpringClientFactory", null);
    private final BeanFactory beanFactory;
    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;
    private SpringClientFactory springClientFactory;

    public PropagationFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof PropagationFeignClient)) {
            if (ribbonPresent && bean instanceof PropagationLoadBalancerFeignClient) {
                return bean;
            }
            if (ribbonPresent && bean instanceof LoadBalancerFeignClient) {
                LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean;
                return new PropagationLoadBalancerFeignClient((Client)this.wrap(client.getDelegate()), this.factory(), this.clientFactory(), this.beanFactory);
            }
            return new LazyPropagationFeignClient(this.beanFactory, (Client)bean);
        }
        return bean;
    }

    private CachingSpringLoadBalancerFactory factory() {
        if (this.cachingSpringLoadBalancerFactory == null) {
            this.cachingSpringLoadBalancerFactory = (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class);
        }
        return this.cachingSpringLoadBalancerFactory;
    }

    private SpringClientFactory clientFactory() {
        if (this.springClientFactory == null) {
            this.springClientFactory = (SpringClientFactory)this.beanFactory.getBean(SpringClientFactory.class);
        }
        return this.springClientFactory;
    }
}

