/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.propagation.instrument.web.client.feign;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Context;
import com.xunyi.micro.propagation.context.CurrentContext;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagationFeignClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(PropagationFeignClient.class);
    static final Propagation.Setter<Map<String, Collection<String>>> SETTER = new Propagation.Setter<Map<String, Collection<String>>>(){

        @Override
        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                ArrayList values = Lists.newArrayList();
                if (value != null) {
                    values.add(value);
                }
                carrier.put(key, values);
            }
        }
    };
    private final CurrentContext currentContext;
    private final Client delegate;
    private Context.Injector<Map<String, Collection<String>>> injector;

    public PropagationFeignClient(CurrentContext currentContext, Propagation propagation, Client delegate) {
        this.currentContext = currentContext;
        this.delegate = delegate;
        this.injector = propagation.injector(SETTER);
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HashMap headers = Maps.newHashMap((Map)request.headers());
        Context context = this.currentContext.get();
        log.debug("execute context: {}", (Object)context);
        this.injector.inject(context, headers);
        return this.delegate.execute(this.modifiedRequest(request, headers), options);
    }

    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        Request.HttpMethod method = request.httpMethod();
        String url = request.url();
        Request.Body body = request.requestBody();
        return Request.create((Request.HttpMethod)method, (String)url, headers, (Request.Body)body);
    }
}

