/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt;

import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.ServerListUpdater;
import com.xunyi.micro.profile.Alpha;
import com.xunyi.micro.profile.Beta;
import com.xunyi.micro.profile.Prod;
import com.xunyi.micro.shunt.loadbalancer.group.ShuntingContextRule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ShuntRibbonClientConfiguration {
    @RibbonClientName
    private String name = "client";

    @Beta
    @Alpha
    @Bean
    public ServerListUpdater testRibbonServerListUpdater() {
        return new PollingServerListUpdater(1000L, 1000L);
    }

    @Prod
    @Bean
    public ServerListUpdater ribbonServerListUpdater() {
        return new PollingServerListUpdater(1000L, 3000L);
    }

    @Bean
    @ConditionalOnMissingBean
    public ShuntingContextRule shuntingRule() {
        return new ShuntingContextRule();
    }
}

