/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.access;

import com.xunyi.micro.core.OperatingSystem;
import java.net.InetSocketAddress;

public class AccessContext {
    private String host;
    private OperatingSystem operatingSystem;
    private InetSocketAddress remoteAddress;

    AccessContext(String host, OperatingSystem operatingSystem, InetSocketAddress remoteAddress) {
        this.host = host;
        this.operatingSystem = operatingSystem;
        this.remoteAddress = remoteAddress;
    }

    public static AccessContextBuilder builder() {
        return new AccessContextBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public static class AccessContextBuilder {
        private String host;
        private OperatingSystem operatingSystem;
        private InetSocketAddress remoteAddress;

        AccessContextBuilder() {
        }

        public AccessContextBuilder host(String host) {
            this.host = host;
            return this;
        }

        public AccessContextBuilder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public AccessContextBuilder remoteAddress(InetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public AccessContext build() {
            return new AccessContext(this.host, this.operatingSystem, this.remoteAddress);
        }

        public String toString() {
            return "AccessContext.AccessContextBuilder(host=" + this.host + ", operatingSystem=" + this.operatingSystem + ", remoteAddress=" + this.remoteAddress + ")";
        }
    }
}

